/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.IfExistsWatcher;
import com.sun.jini.outrigger.TransitionWatcher;
import com.sun.jini.outrigger.TransitionWatchers;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;

class OperationJournal
extends Thread {
    private final TransitionWatchers watchers;
    private JournalNode tail;
    private JournalNode lastProcessed;
    private boolean dead = false;
    private long lastOrdinalUsed = 1L;
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.operations");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationJournal(TransitionWatchers watchers) {
        super("OperationJournal");
        if (watchers == null) {
            throw new NullPointerException("watchers must be non-null");
        }
        this.watchers = watchers;
        OperationJournal operationJournal = this;
        synchronized (operationJournal) {
            this.tail = new JournalNode(null);
        }
        this.lastProcessed = this.tail;
    }

    synchronized void recordTransition(EntryTransition transition) {
        if (transition == null) {
            throw new NullPointerException("transition must be non-null");
        }
        this.post(new JournalNode(transition));
    }

    synchronized void markCaughtUp(IfExistsWatcher watcher) {
        this.post(new JournalNode(new CaughtUpMarker(watcher)));
    }

    synchronized long currentOrdinal() {
        return this.lastOrdinalUsed;
    }

    private void post(JournalNode node) {
        this.tail.next = node;
        this.tail = node;
        this.notifyAll();
    }

    synchronized TransitionIterator newTransitionIterator() {
        return new TransitionIterator(this.tail);
    }

    private synchronized JournalNode lastProcessed(JournalNode noEarlierThan) {
        if (this.lastProcessed.ordinal < noEarlierThan.ordinal) {
            return noEarlierThan;
        }
        return this.lastProcessed;
    }

    synchronized void terminate() {
        this.dead = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.dead) {
            try {
                OperationJournal operationJournal = this;
                synchronized (operationJournal) {
                    JournalNode n = this.lastProcessed.getNext();
                    while (n == null && !this.dead) {
                        this.wait();
                        n = this.lastProcessed.getNext();
                    }
                    if (this.dead) {
                        return;
                    }
                    this.lastProcessed = n;
                }
                Object payload = this.lastProcessed.payload;
                if (payload == null) {
                    throw new AssertionError((Object)"JournalNode with null payload");
                }
                if (payload instanceof EntryTransition) {
                    EntryTransition t = (EntryTransition)payload;
                    SortedSet set = this.watchers.allMatches(t, this.lastProcessed.ordinal);
                    long now = System.currentTimeMillis();
                    Iterator i = set.iterator();
                    while (i.hasNext() && !this.dead) {
                        TransitionWatcher watcher = (TransitionWatcher)i.next();
                        watcher.process(t, now);
                    }
                    continue;
                }
                if (payload instanceof CaughtUpMarker) {
                    ((CaughtUpMarker)payload).watcher.caughtUp();
                    continue;
                }
                throw new AssertionError((Object)("JournalNode with unknown payload:" + payload.getClass()));
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable t) {
                try {
                    logger.log(Level.INFO, "OperationJournal.run encountered " + t.getClass().getName() + ", continuing", t);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    class TransitionIterator {
        private JournalNode end;
        private JournalNode current;

        private TransitionIterator(JournalNode node) {
            if (node == null) {
                throw new NullPointerException("node must be non-null");
            }
            this.current = node;
        }

        EntryTransition next() {
            if (this.end == null) {
                throw new IllegalStateException("watcherRegistered() not yet called");
            }
            if (this.current == null) {
                return null;
            }
            Object payload = this.current.payload;
            while (true) {
                if (this.current == this.end) {
                    this.current = null;
                    if (payload instanceof EntryTransition) {
                        return (EntryTransition)payload;
                    }
                    return null;
                }
                this.current = this.current.getNext();
                assert (this.current != null) : "Iteration when off end";
                if (payload != null && payload instanceof EntryTransition) {
                    return (EntryTransition)payload;
                }
                payload = this.current.payload;
            }
        }

        void watcherRegistered() {
            if (this.end != null) {
                throw new IllegalStateException("watcherRegistered() called more than once");
            }
            this.end = OperationJournal.this.lastProcessed(this.current);
            if (this.current == this.end) {
                this.current = null;
                return;
            }
            this.current = this.current.getNext();
        }

        long currentOrdinalAtCreation() {
            if (this.end != null) {
                throw new IllegalStateException("watcherRegistered() has been called");
            }
            return this.current.ordinal;
        }
    }

    private class CaughtUpMarker {
        private final IfExistsWatcher watcher;

        private CaughtUpMarker(IfExistsWatcher watcher) {
            if (watcher == null) {
                throw new NullPointerException("watcher must not be null");
            }
            this.watcher = watcher;
        }
    }

    private class JournalNode {
        private JournalNode next;
        private final long ordinal;
        private final Object payload;

        private JournalNode(Object payload) {
            this.ordinal = ++OperationJournal.this.lastOrdinalUsed;
            this.payload = payload;
        }

        private synchronized void setNext(JournalNode n) {
            if (this.next != null) {
                throw new IllegalStateException("Already has next");
            }
            if (n == null) {
                throw new NullPointerException("n must be non-null");
            }
            this.next = n;
        }

        private synchronized JournalNode getNext() {
            return this.next;
        }
    }
}

