/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryHandle;
import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.IfExistsWatcher;
import com.sun.jini.outrigger.SingletonQueryWatcher;
import java.util.Set;

class ReadIfExistsWatcher
extends SingletonQueryWatcher
implements IfExistsWatcher {
    private final Set lockedEntries;
    private boolean backlogFinished = false;

    ReadIfExistsWatcher(long expiration, long timestamp, long startOrdinal, Set lockedEntries) {
        super(expiration, timestamp, startOrdinal);
        if (lockedEntries == null) {
            throw new NullPointerException("lockedEntries must be non-null");
        }
        this.lockedEntries = lockedEntries;
    }

    @Override
    boolean isInterested(EntryTransition transition, long ordinal) {
        if (!transition.isVisible() && transition.isAvailable()) {
            return false;
        }
        return ordinal > this.startOrdinal && !this.isResolved();
    }

    @Override
    synchronized void process(EntryTransition transition, long now) {
        if (this.isResolved()) {
            return;
        }
        EntryRep rep = transition.getHandle().rep();
        boolean isVisible = transition.isVisible();
        if (isVisible && transition.getTxn() == null) {
            this.resolve(transition.getHandle(), null);
        } else if (isVisible) {
            this.lockedEntries.add(rep.id());
        } else {
            this.lockedEntries.remove(rep.id());
            if (this.backlogFinished && this.lockedEntries.isEmpty()) {
                this.resolve(null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized boolean catchUp(EntryTransition transition, long now) {
        if (this.isResolved()) {
            return true;
        }
        EntryHandle handle = transition.getHandle();
        EntryRep rep = handle.rep();
        boolean isVisible = transition.isVisible();
        if (!isVisible && transition.isAvailable()) {
            return false;
        }
        if (isVisible && transition.getTxn() == null) {
            this.resolve(handle, null);
            return true;
        }
        if (isVisible) {
            EntryHandle entryHandle = handle;
            synchronized (entryHandle) {
                if (!handle.removed()) {
                    this.lockedEntries.add(rep.id());
                }
            }
            return false;
        }
        this.lockedEntries.remove(rep.id());
        return false;
    }

    @Override
    public synchronized void caughtUp() {
        this.backlogFinished = true;
        if (this.isResolved()) {
            return;
        }
        if (this.lockedEntries.isEmpty()) {
            this.resolve(null, null);
        }
    }

    @Override
    public synchronized boolean isLockedEntrySetEmpty() {
        if (!this.isResolved()) {
            throw new IllegalStateException("Query not yet resolved");
        }
        return this.lockedEntries.isEmpty();
    }
}

