/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import com.sun.jini.phoenix.AccessILFactory;
import com.sun.jini.phoenix.ActivationGroupData;
import com.sun.jini.phoenix.InactiveGroupException;
import com.sun.jini.phoenix.MonitorPermission;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.ExportException;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.loader.RiverClassLoader;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.Security;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

public class ActivationGroupImpl
extends net.jini.activation.ActivationGroup
implements ServerProxyTrust {
    private static final long serialVersionUID = 5758693559430427303L;
    private static final String PHOENIX = "com.sun.jini.phoenix";
    private static final int UNUSED = 0;
    private static final int CREATING = 1;
    private static final int CREATED = 2;
    private static final int ACTIVE = 3;
    private static final int INACTIVE = 4;
    private static Class[] paramTypes = new Class[]{ActivationID.class, MarshalledObject.class};
    private static final ObjectStreamField[] serialPersistentFields = ObjectStreamClass.NO_FIELDS;
    private static int state = 0;
    private static long incarnation;
    private static ActivationGroupID groupID;
    private static LoginContext login;
    private static Exporter exporter;
    private static boolean refuseCalls;
    private static ProxyPreparer monPreparer;
    private static ActivationMonitor monitor;
    private static long unexportTimeout;
    private static long unexportWait;
    private static Map active;
    private static List lockedIDs;
    private static boolean inheritGroupSubject;
    private static final Permission activeObjectPermission;
    private static Permission inactiveObjectPermission;
    private ActivationInstantiator proxy;

    public static synchronized ActivationGroup createGroup(final ActivationGroupID id, final ActivationGroupDesc desc, final long incarnation) throws ActivationException {
        if (state != 0) {
            throw new ActivationException("group previously created");
        }
        try {
            final Configuration config = ActivationGroupImpl.getConfiguration(desc.getData());
            login = (LoginContext)config.getEntry(PHOENIX, "loginContext", LoginContext.class, null);
            if (login != null) {
                login.login();
            }
            inheritGroupSubject = (Boolean)config.getEntry(PHOENIX, "inheritGroupSubject", Boolean.TYPE, Boolean.FALSE);
            ActivationGroup activationGroup = (ActivationGroup)ActivationGroupImpl.doAction(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ProxyPreparer sysPreparer = ActivationGroupImpl.getPreparer(config, "systemPreparer");
                    monPreparer = ActivationGroupImpl.getPreparer(config, "monitorPreparer");
                    TcpServerEndpoint se = TcpServerEndpoint.getInstance(0);
                    BasicJeriExporter defaultExporter = new BasicJeriExporter(se, new AccessILFactory());
                    exporter = (Exporter)config.getEntry(ActivationGroupImpl.PHOENIX, "instantiatorExporter", Exporter.class, defaultExporter);
                    if (exporter == null) {
                        exporter = new AlreadyExportedExporter();
                    }
                    refuseCalls = !(exporter instanceof AlreadyExportedExporter);
                    unexportTimeout = ActivationGroupImpl.getInt(config, "unexportTimeout", 60000);
                    unexportWait = ActivationGroupImpl.getInt(config, "unexportWait", 10);
                    ActivationSystem sys = (ActivationSystem)sysPreparer.prepareProxy(id.getSystem());
                    incarnation = incarnation;
                    groupID = id;
                    state = 1;
                    ActivationGroupID gid = sys == id.getSystem() ? id : new WrappedGID(id, sys);
                    ActivationGroup group = net.jini.activation.ActivationGroup.createGroup(gid, desc, incarnation);
                    state = 3;
                    return group;
                }
            });
            return activationGroup;
        }
        catch (ActivationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActivationException("creation failed", (Throwable)e);
        }
        finally {
            if (state != 3) {
                ActivationGroupImpl.checkInactiveGroup();
            }
        }
    }

    private static Configuration getConfiguration(MarshalledObject mobj) throws ConfigurationException, IOException, ClassNotFoundException {
        ClassLoader ccl;
        ActivationGroupData data = (ActivationGroupData)mobj.get();
        ClassLoader cl = ActivationGroupImpl.class.getClassLoader();
        if (!ActivationGroupImpl.covers(cl, ccl = Thread.currentThread().getContextClassLoader())) {
            cl = ccl;
        }
        return ConfigurationProvider.getInstance(data.getConfig(), cl);
    }

    private static boolean covers(ClassLoader sub, ClassLoader sup) {
        if (sup == null) {
            return true;
        }
        if (sub == null) {
            return false;
        }
        do {
            if (sub != sup) continue;
            return true;
        } while ((sub = sub.getParent()) != null);
        return false;
    }

    private static ProxyPreparer getPreparer(Configuration config, String name) throws ConfigurationException {
        return (ProxyPreparer)config.getEntry(PHOENIX, name, ProxyPreparer.class, new BasicProxyPreparer());
    }

    private static int getInt(Configuration config, String name, int defValue) throws ConfigurationException {
        return (Integer)config.getEntry(PHOENIX, name, Integer.TYPE, defValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivationGroupImpl(ActivationGroupID id, MarshalledObject data) throws ActivationException, RemoteException {
        super(id);
        Class<ActivationGroupImpl> clazz = ActivationGroupImpl.class;
        synchronized (ActivationGroupImpl.class) {
            if (state != 1) {
                throw new ActivationException("not called from createGroup");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (refuseCalls) {
                ActivationGroupImpl.unexportObject((Remote)((Object)this), (boolean)true);
                refuseCalls = false;
            }
            this.proxy = (ActivationInstantiator)exporter.export((Remote)((Object)this));
            try {
                monitor = (ActivationMonitor)monPreparer.prepareProxy(id.getSystem().activeGroup(id, this.proxy, incarnation));
                state = 2;
            }
            finally {
                if (state != 2) {
                    exporter.unexport(true);
                }
            }
            monPreparer = null;
            return;
        }
    }

    @Override
    public TrustVerifier getProxyVerifier() {
        return new BasicProxyTrustVerifier(this.proxy);
    }

    protected Object writeReplace() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLock(ActivationID id) {
        while (true) {
            ActivationID activationID = id;
            synchronized (activationID) {
                List list = lockedIDs;
                synchronized (list) {
                    int index = lockedIDs.indexOf(id);
                    if (index < 0) {
                        lockedIDs.add(id);
                        return;
                    }
                    ActivationID lockedID = (ActivationID)lockedIDs.get(index);
                    if (lockedID != id) {
                        id = lockedID;
                        continue;
                    }
                }
                try {
                    id.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(ActivationID id) {
        List list = lockedIDs;
        synchronized (list) {
            id = (ActivationID)lockedIDs.remove(lockedIDs.indexOf(id));
        }
        list = id;
        synchronized (list) {
            id.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarshalledObject newInstance(final ActivationID id, final ActivationDesc desc) throws ActivationException {
        Class<ActivationGroupImpl> clazz = ActivationGroupImpl.class;
        synchronized (ActivationGroupImpl.class) {
            if (refuseCalls) {
                throw new SecurityException("call refused");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.acquireLock(id);
            try {
                Object object = ActivationGroupImpl.class;
                synchronized (ActivationGroupImpl.class) {
                    if (state != 3) {
                        throw new InactiveGroupException("group not active");
                    }
                    ActiveEntry entry = (ActiveEntry)active.get(id);
                    // ** MonitorExit[var4_10] (shouldn't be in output)
                    if (entry != null) {
                        object = entry.mobj;
                        return object;
                    }
                    String className = desc.getClassName();
                    final Class<?> cl = RiverClassLoader.loadClass(desc.getLocation(), className);
                    final Thread t = Thread.currentThread();
                    final ClassLoader savedCcl = t.getContextClassLoader();
                    final ClassLoader ccl = ActivationGroupImpl.covers(cl.getClassLoader(), savedCcl) ? cl.getClassLoader() : savedCcl;
                    Remote impl = null;
                    try {
                        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public Object run() throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, ActivationException {
                                Object[] params = new Object[]{id, desc.getData()};
                                Constructor constructor = cl.getDeclaredConstructor(paramTypes);
                                constructor.setAccessible(true);
                                try {
                                    t.setContextClassLoader(ccl);
                                    Object t2 = constructor.newInstance(params);
                                    return t2;
                                }
                                finally {
                                    t.setContextClassLoader(savedCcl);
                                }
                            }
                        };
                        impl = (Remote)(inheritGroupSubject ? Security.doPrivileged(action) : AccessController.doPrivileged(action));
                    }
                    catch (PrivilegedActionException pae) {
                        throw pae.getException();
                    }
                    entry = new ActiveEntry(impl);
                    Object object2 = ActivationGroupImpl.class;
                    synchronized (ActivationGroupImpl.class) {
                        active.put(id, entry);
                        // ** MonitorExit[var10_17] (shouldn't be in output)
                        object2 = entry.mobj;
                        return object2;
                    }
                }
            }
            catch (NoSuchMethodException e) {
                throw new ActivationException("activation constructor not defined", (Throwable)e);
            }
            catch (NoSuchMethodError e) {
                throw new ActivationException("activation constructor not defined", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ActivationException("exception constructing object", e.getTargetException());
            }
            catch (ActivationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ActivationException("unable to activate object", (Throwable)e);
            }
            finally {
                this.releaseLock(id);
                ActivationGroupImpl.checkInactiveGroup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean inactiveObject(final ActivationID id) throws ActivationException, RemoteException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(inactiveObjectPermission);
        }
        this.acquireLock(id);
        try {
            Class<ActivationGroupImpl> clazz = ActivationGroupImpl.class;
            synchronized (ActivationGroupImpl.class) {
                if (state != 3) {
                    throw new InactiveGroupException("group not active");
                }
                ActiveEntry entry = (ActiveEntry)active.get(id);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                if (entry == null) {
                    throw new UnknownObjectException("object not active");
                }
                try {
                    if (!Activatable.unexportObject((Remote)entry.impl, (boolean)false)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (NoSuchObjectException allowUnexportedObjects) {
                    // empty catch block
                }
                try {
                    ActivationGroupImpl.doAction(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            monitor.inactiveObject(id);
                            return null;
                        }
                    });
                }
                catch (UnknownObjectException allowUnregisteredObjects) {
                    // empty catch block
                }
                clazz = ActivationGroupImpl.class;
                synchronized (ActivationGroupImpl.class) {
                    active.remove(id);
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return true;
                }
            }
        }
        finally {
            this.releaseLock(id);
            ActivationGroupImpl.checkInactiveGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean inactiveObject(final ActivationID id, Exporter exporter) throws ActivationException, RemoteException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(inactiveObjectPermission);
        }
        this.acquireLock(id);
        try {
            Class<ActivationGroupImpl> clazz = ActivationGroupImpl.class;
            synchronized (ActivationGroupImpl.class) {
                if (state != 3) {
                    throw new InactiveGroupException("group not active");
                }
                ActiveEntry entry = (ActiveEntry)active.get(id);
                // ** MonitorExit[var5_4] (shouldn't be in output)
                if (entry == null) {
                    throw new UnknownObjectException("object not active");
                }
                if (!exporter.unexport(false)) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    ActivationGroupImpl.doAction(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            monitor.inactiveObject(id);
                            return null;
                        }
                    });
                }
                catch (UnknownObjectException allowUnregisteredObjects) {
                    // empty catch block
                }
                clazz = ActivationGroupImpl.class;
                synchronized (ActivationGroupImpl.class) {
                    active.remove(id);
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return true;
                }
            }
        }
        finally {
            this.releaseLock(id);
            ActivationGroupImpl.checkInactiveGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkInactiveGroup() {
        Class<ActivationGroupImpl> clazz = ActivationGroupImpl.class;
        synchronized (ActivationGroupImpl.class) {
            if (state == 3) {
                if (!active.isEmpty() || !lockedIDs.isEmpty()) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                state = 4;
            } else {
                if (state == 4) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                if (state == 2) {
                    state = 0;
                } else {
                    if (login != null) {
                        try {
                            login.logout();
                        }
                        catch (LoginException e) {
                            // empty catch block
                        }
                        login = null;
                    }
                    state = 0;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            try {
                ActivationGroupImpl.doAction(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        monitor.inactiveGroup(groupID, incarnation);
                        return null;
                    }
                });
            }
            catch (Exception ignoreDeactivateFailure) {
                // empty catch block
            }
            Runnable action = new Runnable(){

                @Override
                public void run() {
                    long stop = System.currentTimeMillis() + unexportTimeout;
                    boolean force = false;
                    while (!exporter.unexport(force)) {
                        long rem = stop - System.currentTimeMillis();
                        if (rem <= 0L) {
                            force = true;
                            continue;
                        }
                        try {
                            Thread.sleep(Math.min(rem, unexportWait));
                        }
                        catch (InterruptedException e) {}
                    }
                    if (login != null) {
                        try {
                            login.logout();
                        }
                        catch (LoginException e) {
                            // empty catch block
                        }
                    }
                }
            };
            if (state == 0) {
                action.run();
            } else {
                Executor systemThreadPool = (Executor)AccessController.doPrivileged(login == null ? new GetThreadPoolAction(false) : new PrivilegedAction(){

                    public Object run() {
                        return Subject.doAsPrivileged(login.getSubject(), new GetThreadPoolAction(false), null);
                    }
                });
                systemThreadPool.execute(action, "UnexportGroup");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeObject(final ActivationID id, Remote impl) throws ActivationException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(activeObjectPermission);
        }
        final ActiveEntry entry = new ActiveEntry(impl);
        this.acquireLock(id);
        try {
            Class<ActivationGroupImpl> clazz = ActivationGroupImpl.class;
            synchronized (ActivationGroupImpl.class) {
                block12: {
                    if (state != 3) {
                        throw new InactiveGroupException("group not active");
                    }
                    if (!active.containsKey(id)) break block12;
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
                active.put(id, entry);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                try {
                    ActivationGroupImpl.doAction(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            monitor.activeObject(id, entry.mobj);
                            return null;
                        }
                    });
                }
                catch (RemoteException ignore) {
                    // empty catch block
                }
            }
        }
        finally {
            this.releaseLock(id);
            ActivationGroupImpl.checkInactiveGroup();
        }
        {
            return;
        }
    }

    private static Object doAction(final PrivilegedExceptionAction action) throws ActivationException, RemoteException {
        try {
            if (login == null) {
                return AccessController.doPrivileged(action);
            }
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        return Subject.doAsPrivileged(login.getSubject(), action, null);
                    }
                    catch (PrivilegedActionException e) {
                        throw e.getException();
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            if (ex instanceof ActivationException) {
                throw (ActivationException)((Object)ex);
            }
            throw new ActivationException("unexpected failure", (Throwable)ex);
        }
    }

    static {
        refuseCalls = false;
        active = new HashMap();
        lockedIDs = new ArrayList();
        activeObjectPermission = new MonitorPermission("java.rmi.activation.ActivationMonitor.activeObject");
        inactiveObjectPermission = new MonitorPermission("java.rmi.activation.ActivationMonitor.inactiveObject");
    }

    private static class ActiveEntry {
        Remote impl;
        MarshalledObject mobj;

        ActiveEntry(Remote impl) throws ActivationException {
            this.impl = impl;
            try {
                Object proxy;
                if (impl instanceof ProxyAccessor) {
                    proxy = ((ProxyAccessor)((Object)impl)).getProxy();
                    if (proxy == null) {
                        throw new ActivationException("ProxyAccessor.getProxy returned null");
                    }
                } else {
                    proxy = impl;
                }
                this.mobj = new MarshalledObject<Object>(proxy);
            }
            catch (IOException e) {
                throw new ActivationException("failed to marshal remote object", (Throwable)e);
            }
        }
    }

    private static class AlreadyExportedExporter
    implements Exporter {
        private Remote impl;

        AlreadyExportedExporter() {
        }

        @Override
        public synchronized Remote export(Remote impl) throws ExportException {
            this.impl = impl;
            try {
                return RemoteObject.toStub(impl);
            }
            catch (NoSuchObjectException e) {
                throw new ExportException("no stub found", e);
            }
        }

        @Override
        public synchronized boolean unexport(boolean force) {
            try {
                if (this.impl != null && !UnicastRemoteObject.unexportObject(this.impl, force)) {
                    return false;
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            this.impl = null;
            return true;
        }
    }

    private static class WrappedGID
    extends ActivationGroupID {
        private final ActivationGroupID id;
        private final ActivationSystem sys;

        WrappedGID(ActivationGroupID id, ActivationSystem sys) {
            super(sys);
            this.id = id;
            this.sys = sys;
        }

        public ActivationSystem getSystem() {
            return this.sys;
        }

        private Object writeReplace() {
            return this.id;
        }
    }
}

