/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

public class InProgress {
    private int count = 0;
    private String name;
    private boolean debug;

    public InProgress(String name) {
        this.name = name;
    }

    public synchronized void start() throws InterruptedException {
        while (this.count < 0) {
            this.wait();
        }
        ++this.count;
        if (this.debug) {
            this.show("start");
        }
    }

    public synchronized void stop() {
        if (--this.count == 0) {
            this.notifyAll();
        }
        if (this.count < 0) {
            this.count = 0;
            throw new IllegalMonitorStateException("Too many stop invocations");
        }
        if (this.debug) {
            this.show("stop");
        }
    }

    public boolean inProgress() {
        return this.count > 0;
    }

    public synchronized void waitWhileStarted() throws InterruptedException {
        if (this.debug) {
            this.show("waitWhileStarted");
        }
        while (this.count > 0) {
            this.wait();
            if (!this.debug) continue;
            this.show("waitWhileStarted");
        }
    }

    public synchronized void block() throws InterruptedException {
        while (this.count > 0) {
            this.wait();
        }
        --this.count;
        if (this.debug) {
            this.show("block");
        }
    }

    public synchronized void unblock() {
        if (++this.count == 0) {
            this.notifyAll();
        }
        if (this.count > 0) {
            this.count = 0;
            throw new IllegalMonitorStateException("Too many unblock invocations");
        }
        if (this.debug) {
            this.show("unblock");
        }
    }

    public boolean blocked() {
        return this.count < 0;
    }

    public synchronized void waitWhileBlocked() throws InterruptedException {
        if (this.debug) {
            this.show("waitWhileBlocked");
        }
        while (this.count < 0) {
            this.wait();
            if (!this.debug) continue;
            this.show("waitWhileBlocked");
        }
    }

    public synchronized void waitUntilQuiet() throws InterruptedException {
        if (this.debug) {
            this.show("waitUntilQuiet");
        }
        while (this.count != 0) {
            this.wait();
            if (!this.debug) continue;
            this.show("waitUntilQuiet");
        }
    }

    public void debug(boolean debugOn) {
        this.debug = debugOn;
    }

    private void show(String label) {
        System.out.print(this.name);
        System.out.print(":");
        System.out.print(label);
        System.out.print(": count = ");
        System.out.println(this.count);
    }
}

