/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Vector;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.Constants;

public class OutgoingMulticastRequest {
    protected static final int minMaxPacketSize = 512;
    protected static final int protocolVersion = 1;

    public static DatagramPacket[] marshal(int responsePort, String[] groups, ServiceID[] heard) throws IOException {
        return OutgoingMulticastRequest.marshal(responsePort, groups, heard, 512);
    }

    public static DatagramPacket[] marshal(int responsePort, String[] groups, ServiceID[] heard, int maxPacketSize) throws IOException {
        int count;
        if (maxPacketSize < 512) {
            throw new IllegalArgumentException("maxPacketSize (" + maxPacketSize + ") is " + "less than minMaxPacketSize (" + 512 + ")");
        }
        ByteArrayOutputStream hbs = new ByteArrayOutputStream();
        DataOutputStream hos = new DataOutputStream(hbs);
        hos.writeInt(1);
        hos.writeInt(responsePort);
        byte[] marshaledHeader = hbs.toByteArray();
        byte[][] marshaledGroups = new byte[groups.length][];
        int longestGroup = -1;
        for (int i = 0; i < groups.length; ++i) {
            ByteArrayOutputStream gbs = new ByteArrayOutputStream();
            DataOutputStream gos = new DataOutputStream(gbs);
            gos.writeUTF(groups[i]);
            gos.flush();
            marshaledGroups[i] = gbs.toByteArray();
            if (marshaledHeader.length + 4 + 4 + marshaledGroups[i].length > maxPacketSize) {
                throw new IllegalArgumentException("group name marshals too large (" + marshaledGroups[i].length + " bytes)");
            }
            if (marshaledGroups[i].length <= longestGroup) continue;
            longestGroup = marshaledGroups[i].length;
        }
        int prevTotal = 0;
        int total = 0;
        ByteArrayOutputStream dbs = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(dbs);
        for (count = 0; count < heard.length; ++count) {
            heard[count].writeBytes(dos);
            prevTotal = total;
            total = dbs.size();
            if (marshaledHeader.length + 4 + longestGroup + 4 + total > maxPacketSize) break;
        }
        dos.flush();
        dbs.flush();
        byte[] tmp = dbs.toByteArray();
        ByteArrayOutputStream hbs2 = new ByteArrayOutputStream();
        DataOutputStream hos2 = new DataOutputStream(hbs2);
        hos2.writeInt(count);
        hos2.write(tmp, 0, count == heard.length ? total : prevTotal);
        hos2.flush();
        byte[] marshaledHeard = hbs2.toByteArray();
        Vector<DatagramPacket> reqs = new Vector<DatagramPacket>();
        InetAddress addr = Constants.getRequestAddress();
        if (groups.length == 0) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(maxPacketSize);
            DataOutputStream os = new DataOutputStream(bs);
            os.write(marshaledHeader);
            os.write(marshaledHeard);
            os.writeInt(0);
            os.flush();
            byte[] payload = bs.toByteArray();
            reqs.add(new DatagramPacket(payload, payload.length, addr, 4160));
        } else {
            int curr = 0;
            while (curr < marshaledGroups.length) {
                int last;
                ByteArrayOutputStream bs = new ByteArrayOutputStream(maxPacketSize);
                DataOutputStream os = new DataOutputStream(bs);
                os.write(marshaledHeader);
                os.write(marshaledHeard);
                os.flush();
                int bytes = bs.size() + 4;
                for (last = curr; last < marshaledGroups.length && bytes + marshaledGroups[last].length <= maxPacketSize; ++last) {
                    bytes += marshaledGroups[last].length;
                }
                os.writeInt(last - curr);
                while (curr < last) {
                    os.write(marshaledGroups[curr++]);
                }
                os.flush();
                byte[] payload = bs.toByteArray();
                reqs.add(new DatagramPacket(payload, payload.length, addr, 4160));
            }
        }
        Iterator iter2 = reqs.iterator();
        DatagramPacket[] ary = new DatagramPacket[reqs.size()];
        int i = 0;
        while (iter2.hasNext()) {
            ary[i] = (DatagramPacket)iter2.next();
            ++i;
        }
        return ary;
    }
}

