/*
 * Decompiled with CFR 0.152.
 */
package net.jini.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.jini.io.ObjectStreamContext;
import net.jini.loader.ClassLoading;

public class MarshalInputStream
extends ObjectInputStream
implements ObjectStreamContext {
    private static final Map specialClasses = new HashMap();
    private final Collection context;
    private final ClassLoader defaultLoader;
    private final boolean verifyCodebaseIntegrity;
    private final ClassLoader verifierLoader;
    private boolean usingCodebaseAnnotations = false;

    public MarshalInputStream(InputStream in, ClassLoader defaultLoader, boolean verifyCodebaseIntegrity, ClassLoader verifierLoader, Collection context) throws IOException {
        super(in);
        if (context == null) {
            throw new NullPointerException();
        }
        this.defaultLoader = defaultLoader;
        this.verifyCodebaseIntegrity = verifyCodebaseIntegrity;
        this.verifierLoader = verifierLoader;
        this.context = context;
    }

    public void useCodebaseAnnotations() {
        this.usingCodebaseAnnotations = true;
    }

    @Override
    public Collection getObjectStreamContext() {
        return this.context;
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        if (classDesc == null) {
            throw new NullPointerException();
        }
        String annotation = this.readAnnotation();
        String codebase = this.usingCodebaseAnnotations ? annotation : null;
        String name = classDesc.getName();
        try {
            return ClassLoading.loadClass(codebase, name, this.defaultLoader, this.verifyCodebaseIntegrity, this.verifierLoader);
        }
        catch (ClassNotFoundException e) {
            Class c = (Class)specialClasses.get(name);
            if (c != null) {
                return c;
            }
            throw e;
        }
    }

    protected Class resolveProxyClass(String[] interfaceNames) throws IOException, ClassNotFoundException {
        for (int i = 0; i < interfaceNames.length; ++i) {
            if (interfaceNames[i] != null) continue;
            throw new NullPointerException();
        }
        String annotation = this.readAnnotation();
        String codebase = this.usingCodebaseAnnotations ? annotation : null;
        return ClassLoading.loadProxyClass(codebase, interfaceNames, this.defaultLoader, this.verifyCodebaseIntegrity, this.verifierLoader);
    }

    protected String readAnnotation() throws IOException, ClassNotFoundException {
        try {
            return (String)this.readObject();
        }
        catch (ClassCastException e) {
            InvalidObjectException ioe = new InvalidObjectException("annotation not String or null");
            ioe.initCause(e);
            throw ioe;
        }
    }

    static {
        specialClasses.put("boolean", Boolean.TYPE);
        specialClasses.put("byte", Byte.TYPE);
        specialClasses.put("char", Character.TYPE);
        specialClasses.put("short", Short.TYPE);
        specialClasses.put("int", Integer.TYPE);
        specialClasses.put("long", Long.TYPE);
        specialClasses.put("float", Float.TYPE);
        specialClasses.put("double", Double.TYPE);
        specialClasses.put("void", Void.TYPE);
    }
}

