/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import au.net.zeus.collection.RC;
import au.net.zeus.collection.Ref;
import au.net.zeus.collection.Referrer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Guard;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.security.Security;
import net.jini.security.SecurityContext;
import org.apache.river.api.security.CachingSecurityManager;
import org.apache.river.api.security.PermissionComparator;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class CombinerSecurityManager
extends SecurityManager
implements CachingSecurityManager {
    private static final Logger logger = Logger.getLogger(CombinerSecurityManager.class.getName());
    private final DomainCombiner dc;
    private final ConcurrentMap<AccessControlContext, AccessControlContext> contextCache;
    private final ConcurrentMap<Object, NavigableSet<Permission>> checked;
    private final Guard g;
    private final Action action;
    private final Executor executor;
    private final Comparator<Referrer<Permission>> permCompare;
    private final AccessControlContext SMConstructorContext = AccessController.getContext();
    private final AccessControlContext SMPrivilegedContext;
    private final ProtectionDomain privilegedDomain = this.getClass().getProtectionDomain();
    private final ThreadLocal<SecurityContext> threadContext;
    private final ThreadLocal<Boolean> inTrustedCodeRecursiveCall;

    public CombinerSecurityManager() {
        ProtectionDomain[] context = new ProtectionDomain[]{this.privilegedDomain};
        this.SMPrivilegedContext = new AccessControlContext(context);
        this.dc = new DelegateDomainCombiner();
        NonBlockingHashMap internal = new NonBlockingHashMap();
        this.contextCache = RC.concurrentMap(internal, Ref.TIME, Ref.STRONG, 60000L, 0L);
        NonBlockingHashMap refmap = new NonBlockingHashMap();
        this.checked = RC.concurrentMap(refmap, Ref.TIME, Ref.STRONG, 20000L, 0L);
        this.g = new SecurityPermission("getPolicy");
        SecurityPermission createAccPerm = new SecurityPermission("createAccessControlContext");
        this.action = new Action();
        double blocking_coefficient = 0.6;
        int numberOfCores = Runtime.getRuntime().availableProcessors();
        int poolSizeLimit = (int)((double)numberOfCores / (1.0 - blocking_coefficient));
        this.executor = new ThreadPoolExecutor(numberOfCores, poolSizeLimit, 20L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.permCompare = RC.comparator(new PermissionComparator());
        this.threadContext = new ThreadLocal();
        this.inTrustedCodeRecursiveCall = new ThreadLocal();
        Policy policy = Policy.getPolicy();
        if (!policy.implies(context[0], createAccPerm)) {
            policy.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getSecurityContext() {
        SecurityContext context = null;
        this.inTrustedCodeRecursiveCall.set(Boolean.TRUE);
        try {
            context = Security.getContext();
        }
        finally {
            this.inTrustedCodeRecursiveCall.set(Boolean.FALSE);
        }
        return context;
    }

    @Override
    public void checkPermission(Permission perm) throws SecurityException {
        Boolean call = this.inTrustedCodeRecursiveCall.get();
        if (call == Boolean.TRUE) {
            return;
        }
        Object context = this.getSecurityContext();
        this.checkPermission(perm, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPermission(Permission perm, Object context) throws SecurityException {
        if (perm == null) {
            throw new NullPointerException("Permission Collection null");
        }
        AccessControlContext executionContext = null;
        SecurityContext securityContext = null;
        if (context instanceof AccessControlContext) {
            executionContext = (AccessControlContext)context;
        } else if (context instanceof SecurityContext) {
            securityContext = (SecurityContext)context;
            executionContext = securityContext.getAccessControlContext();
        } else {
            throw new SecurityException();
        }
        this.threadContext.set(securityContext);
        if (this.SMPrivilegedContext.equals(executionContext) || this.SMConstructorContext.equals(executionContext)) {
            return;
        }
        NavigableSet checkedPerms = (NavigableSet)this.checked.get(context);
        if (checkedPerms == null) {
            ConcurrentSkipListSet internal = new ConcurrentSkipListSet(this.permCompare);
            checkedPerms = RC.navigableSet(internal, Ref.TIME, 5000L);
            this.inTrustedCodeRecursiveCall.set(Boolean.TRUE);
            try {
                NavigableSet existed = this.checked.putIfAbsent(context, checkedPerms);
                if (existed != null) {
                    checkedPerms = existed;
                }
            }
            finally {
                this.inTrustedCodeRecursiveCall.set(Boolean.FALSE);
            }
        }
        if (checkedPerms.contains(perm)) {
            return;
        }
        AccessControlContext delegateContext = (AccessControlContext)this.contextCache.get(executionContext);
        if (delegateContext == null) {
            final AccessControlContext finalExecutionContext = executionContext;
            this.inTrustedCodeRecursiveCall.set(Boolean.TRUE);
            try {
                delegateContext = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

                    @Override
                    public AccessControlContext run() {
                        return new AccessControlContext(finalExecutionContext, CombinerSecurityManager.this.dc);
                    }
                });
            }
            finally {
                this.inTrustedCodeRecursiveCall.set(Boolean.FALSE);
            }
            delegateContext = AccessController.doPrivileged(this.action, delegateContext);
            this.inTrustedCodeRecursiveCall.set(Boolean.TRUE);
            try {
                this.contextCache.putIfAbsent(executionContext, delegateContext);
            }
            finally {
                this.inTrustedCodeRecursiveCall.set(Boolean.FALSE);
            }
        }
        delegateContext.checkPermission(perm);
        checkedPerms.add(perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() throws SecurityException {
        this.g.checkGuard(this);
        this.inTrustedCodeRecursiveCall.set(Boolean.TRUE);
        try {
            this.checked.clear();
        }
        finally {
            this.inTrustedCodeRecursiveCall.set(Boolean.FALSE);
        }
    }

    protected boolean checkPermission(ProtectionDomain pd, Permission p) {
        return pd.implies(p);
    }

    private class PermissionCheck
    implements Callable<Boolean> {
        private final ProtectionDomain pd;
        private final Permission p;
        private final CountDownLatch latch;
        private final SecurityContext securityContext;

        PermissionCheck(ProtectionDomain pd, Permission p, CountDownLatch c, SecurityContext sc) {
            if (pd == null || p == null) {
                throw new NullPointerException();
            }
            this.pd = pd;
            this.p = p;
            this.latch = c;
            this.securityContext = sc;
        }

        @Override
        public Boolean call() throws Exception {
            Boolean result = AccessController.doPrivileged(this.securityContext != null ? this.securityContext.wrap(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    boolean result = CombinerSecurityManager.this.checkPermission(PermissionCheck.this.pd, PermissionCheck.this.p);
                    return result;
                }
            }) : new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    boolean result = CombinerSecurityManager.this.checkPermission(PermissionCheck.this.pd, PermissionCheck.this.p);
                    return result;
                }
            });
            this.latch.countDown();
            return result;
        }
    }

    private class DelegateProtectionDomain
    extends ProtectionDomain {
        private final ProtectionDomain[] context;

        DelegateProtectionDomain(ProtectionDomain[] context) {
            super(null, null);
            this.context = context;
        }

        @Override
        public boolean implies(Permission perm) {
            Thread currentThread = Thread.currentThread();
            boolean interrupt = Thread.interrupted();
            int l = this.context.length;
            if (l < 4) {
                for (int i = 0; i < l; ++i) {
                    if (CombinerSecurityManager.this.checkPermission(this.context[i], perm)) continue;
                    if (interrupt) {
                        currentThread.interrupt();
                    }
                    return false;
                }
                if (interrupt) {
                    currentThread.interrupt();
                }
                return true;
            }
            CountDownLatch latch = new CountDownLatch(l);
            ArrayList<FutureTask<Boolean>> resultList = new ArrayList<FutureTask<Boolean>>(l);
            for (int i = 0; i < l; ++i) {
                resultList.add(new FutureTask<Boolean>(new PermissionCheck(this.context[i], perm, latch, (SecurityContext)CombinerSecurityManager.this.threadContext.get())));
            }
            Iterator it = resultList.iterator();
            while (it.hasNext()) {
                CombinerSecurityManager.this.executor.execute((Runnable)it.next());
            }
            try {
                latch.await();
                it = resultList.iterator();
                try {
                    while (it.hasNext()) {
                        Boolean result = (Boolean)((RunnableFuture)it.next()).get();
                        if (!result.equals(Boolean.FALSE)) continue;
                        if (interrupt) {
                            currentThread.interrupt();
                        }
                        return false;
                    }
                    if (interrupt) {
                        currentThread.interrupt();
                    }
                    return true;
                }
                catch (ExecutionException ex) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                    throw new RuntimeException("Unrecoverable: ", ex.getCause());
                }
            }
            catch (InterruptedException ex) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "External Interruption", ex);
                }
                for (int i = 0; i < l; ++i) {
                    if (CombinerSecurityManager.this.checkPermission(this.context[i], perm)) continue;
                    currentThread.interrupt();
                    return false;
                }
                currentThread.interrupt();
                return true;
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(800);
            sb.append("DomainCombinerSecurityManager full stack: \n");
            int l = this.context.length;
            for (int i = 0; i < l; ++i) {
                sb.append(this.context[i].toString());
            }
            return sb.toString();
        }
    }

    private class DelegateDomainCombiner
    implements DomainCombiner {
        private DelegateDomainCombiner() {
        }

        @Override
        public ProtectionDomain[] combine(ProtectionDomain[] currentDomains, ProtectionDomain[] assignedDomains) {
            int l = assignedDomains.length;
            ArrayList<ProtectionDomain> list = new ArrayList<ProtectionDomain>(l);
            for (int i = 0; i < l; ++i) {
                if (assignedDomains[i] == CombinerSecurityManager.this.privilegedDomain) continue;
                list.add(assignedDomains[i]);
            }
            ProtectionDomain[] context = list.toArray(new ProtectionDomain[list.size()]);
            ProtectionDomain[] delegated = new DelegateProtectionDomain[]{new DelegateProtectionDomain(context)};
            return delegated;
        }
    }

    private static class Action
    implements PrivilegedAction<AccessControlContext> {
        private Action() {
        }

        @Override
        public AccessControlContext run() {
            return AccessController.getContext();
        }
    }
}

