/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.Principal;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.river.api.security.DefaultPolicyScanner;
import org.apache.river.api.security.Messages;
import org.apache.river.api.security.PermissionGrant;
import org.apache.river.api.security.PermissionGrantBuilder;
import org.apache.river.api.security.PolicyParser;
import org.apache.river.api.security.PolicyUtils;
import org.apache.river.api.security.Segment;
import org.apache.river.api.security.UnresolvedPrincipal;
import org.apache.river.impl.net.UriString;

class DefaultPolicyParser
implements PolicyParser {
    private final DefaultPolicyScanner scanner;

    DefaultPolicyParser() {
        this.scanner = new DefaultPolicyScanner();
    }

    DefaultPolicyParser(DefaultPolicyScanner s) {
        this.scanner = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PermissionGrant> parse(URL location, Properties system) throws Exception {
        boolean resolve = PolicyUtils.canExpandProperties();
        BufferedReader r = new BufferedReader(new InputStreamReader(AccessController.doPrivileged(new PolicyUtils.URLLoader(location))));
        HashSet<DefaultPolicyScanner.GrantEntry> grantEntries = new HashSet<DefaultPolicyScanner.GrantEntry>();
        ArrayList<DefaultPolicyScanner.KeystoreEntry> keystores = new ArrayList<DefaultPolicyScanner.KeystoreEntry>();
        try {
            this.scanner.scanStream(r, grantEntries, keystores);
        }
        finally {
            ((Reader)r).close();
        }
        KeyStore ks = this.initKeyStore(keystores, location, system, resolve);
        HashSet<PermissionGrant> result = new HashSet<PermissionGrant>();
        for (DefaultPolicyScanner.GrantEntry ge : grantEntries) {
            try {
                PermissionGrant pe = this.resolveGrant(ge, ks, system, resolve);
                if (pe.isVoid()) continue;
                result.add(pe);
            }
            catch (Exception e) {
                if (e instanceof SecurityException) {
                    throw (SecurityException)e;
                }
                System.err.println("Problem parsing policy: " + location + "\n" + e);
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    PermissionGrant resolveGrant(DefaultPolicyScanner.GrantEntry ge, KeyStore ks, Properties system, boolean resolve) throws Exception {
        Collection<DefaultPolicyScanner.PermissionEntry> pec;
        if (ge == null) {
            return null;
        }
        ArrayList<URI> codebases = new ArrayList<URI>(8);
        Certificate[] signers = null;
        HashSet<Principal> principals = new HashSet<Principal>();
        HashSet<Permission> permissions = new HashSet<Permission>();
        String cb = ge.getCodebase(null);
        String signerString = ge.getSigners();
        if (cb != null) {
            if (resolve) {
                try {
                    Collection<String> cbstr = this.expandURLs(cb, system);
                    Iterator<String> it = cbstr.iterator();
                    while (it.hasNext()) {
                        codebases.add(this.getURI(it.next()));
                    }
                }
                catch (PolicyUtils.ExpansionFailedException e) {
                    codebases.add(this.getURI(cb));
                }
            } else {
                codebases.add(this.getURI(cb));
            }
        }
        if (signerString != null) {
            if (resolve) {
                signerString = PolicyUtils.expand(signerString, system);
            }
            signers = this.resolveSigners(ks, signerString);
        }
        if (ge.getPrincipals(null) != null) {
            String principalName = null;
            String principalClass = null;
            for (DefaultPolicyScanner.PrincipalEntry pe : ge.getPrincipals(system)) {
                principalName = pe.getName();
                principalClass = pe.getKlass();
                if (resolve) {
                    principalName = PolicyUtils.expand(principalName, system);
                }
                if (principalClass == null) {
                    principals.add(this.getPrincipalByAlias(ks, principalName));
                    continue;
                }
                principals.add(new UnresolvedPrincipal(principalClass, principalName));
            }
        }
        if ((pec = ge.getPermissions()) != null) {
            for (DefaultPolicyScanner.PermissionEntry pe : pec) {
                try {
                    permissions.add(this.resolvePermission(pe, ge, ks, system, resolve));
                }
                catch (Exception e) {
                    if (e instanceof SecurityException) {
                        throw (SecurityException)e;
                    }
                    System.err.println(e);
                }
            }
        }
        PermissionGrantBuilder pgb = PermissionGrantBuilder.newBuilder();
        Iterator<DefaultPolicyScanner.PrincipalEntry> iter2 = codebases.iterator();
        while (iter2.hasNext()) {
            pgb.uri((URI)((Object)iter2.next()));
        }
        return pgb.certificates(signers).principals(principals.toArray(new Principal[principals.size()])).permissions(permissions.toArray(new Permission[permissions.size()])).context(4).build();
    }

    URI getURI(String uriString) throws MalformedURLException, URISyntaxException {
        if (uriString == null) {
            return null;
        }
        uriString = UriString.fixWindowsURI(uriString);
        uriString = UriString.escapeIllegalCharacters(uriString);
        return new URI(uriString);
    }

    Segment segment(String s, Properties p) throws PolicyUtils.ExpansionFailedException {
        String ARRAY_START_MARK = "${{";
        String ARRAY_END_MARK = "}}";
        String ARRAY_SEPARATOR = p.getProperty("path.separator");
        String START_MARK = "${";
        String END_MARK = "}";
        Segment primary = new Segment(s, null);
        primary.divideAndReplace("${{", "}}", ARRAY_SEPARATOR, p);
        primary.divideAndReplace("${", "}", null, p);
        primary.divideAndReplace("${", "}", null, p);
        primary.divideAndReplace("${", "}", null, p);
        return primary;
    }

    Collection<String> expandURLs(String s, Properties p) throws PolicyUtils.ExpansionFailedException {
        Segment seg = this.segment(s, p);
        ArrayList<String> urls = new ArrayList<String>();
        while (seg.hasNext()) {
            urls.add(seg.next());
        }
        return urls;
    }

    Permission resolvePermission(DefaultPolicyScanner.PermissionEntry pe, DefaultPolicyScanner.GrantEntry ge, KeyStore ks, Properties system, boolean resolve) throws Exception {
        String className = pe.getKlass();
        String name = pe.getName();
        String actions = pe.getActions();
        String signer = pe.getSigners();
        if (name != null) {
            name = PolicyUtils.expandGeneral(name, new PermissionExpander(ge, ks));
        }
        if (resolve) {
            if (name != null) {
                name = PolicyUtils.expand(name, system);
            }
            if (actions != null) {
                actions = PolicyUtils.expand(actions, system);
            }
            if (signer != null) {
                signer = PolicyUtils.expand(signer, system);
            }
        }
        Object[] signers = signer == null ? null : this.resolveSigners(ks, signer);
        try {
            Class<?> klass = Class.forName(className);
            if (PolicyUtils.matchSubset(signers, klass.getSigners())) {
                return PolicyUtils.instantiatePermission(klass, name, actions);
            }
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        return new UnresolvedPermission(className, name, actions, (Certificate[])signers);
    }

    Certificate[] resolveSigners(KeyStore ks, String signers) throws Exception {
        if (ks == null) {
            throw new KeyStoreException(Messages.getString("security.146", signers));
        }
        HashSet<Certificate> certs = new HashSet<Certificate>();
        StringTokenizer snt = new StringTokenizer(signers, ",");
        while (snt.hasMoreTokens()) {
            certs.add(ks.getCertificate(snt.nextToken().trim()));
        }
        return certs.toArray(new Certificate[certs.size()]);
    }

    Principal getPrincipalByAlias(KeyStore ks, String alias) throws KeyStoreException, CertificateException {
        if (ks == null) {
            throw new KeyStoreException(Messages.getString("security.147", alias));
        }
        Certificate x509 = ks.getCertificate(alias);
        if (x509 instanceof X509Certificate) {
            return ((X509Certificate)x509).getSubjectX500Principal();
        }
        throw new CertificateException(Messages.getString("security.148", alias, x509));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyStore initKeyStore(List<DefaultPolicyScanner.KeystoreEntry> keystores, URL base, Properties system, boolean resolve) {
        for (int i = 0; i < keystores.size(); ++i) {
            try {
                DefaultPolicyScanner.KeystoreEntry ke = keystores.get(i);
                String url = ke.getUrl();
                String type = ke.getType();
                if (resolve) {
                    url = PolicyUtils.expandURL(url, system);
                    if (type != null) {
                        type = PolicyUtils.expand(type, system);
                    }
                }
                if (type == null || type.length() == 0) {
                    type = KeyStore.getDefaultType();
                }
                KeyStore ks = KeyStore.getInstance(type);
                URL location = new URL(base, url);
                InputStream is = AccessController.doPrivileged(new PolicyUtils.URLLoader(location));
                try {
                    ks.load(is, null);
                }
                finally {
                    is.close();
                }
                return ks;
            }
            catch (Exception e) {
                if (e instanceof SecurityException) {
                    throw (SecurityException)e;
                }
                e.printStackTrace(System.err);
                continue;
            }
        }
        return null;
    }

    class PermissionExpander
    implements PolicyUtils.GeneralExpansionHandler {
        private final KeyStore ks;
        private final DefaultPolicyScanner.GrantEntry ge;

        PermissionExpander(DefaultPolicyScanner.GrantEntry ge, KeyStore ks) {
            this.ge = ge;
            this.ks = ks;
        }

        @Override
        public String resolve(String protocol, String data) throws PolicyUtils.ExpansionFailedException {
            if ("self".equals(protocol)) {
                if (this.ge.getPrincipals(null) != null && this.ge.getPrincipals(null).size() != 0) {
                    StringBuilder sb = new StringBuilder();
                    for (DefaultPolicyScanner.PrincipalEntry pr : this.ge.getPrincipals(null)) {
                        if (pr.getKlass() == null) {
                            try {
                                sb.append(this.pc2str(DefaultPolicyParser.this.getPrincipalByAlias(this.ks, pr.getName())));
                                continue;
                            }
                            catch (Exception e) {
                                if (e instanceof SecurityException) {
                                    throw (SecurityException)e;
                                }
                                throw new PolicyUtils.ExpansionFailedException(Messages.getString("security.143", pr.getName()), e);
                            }
                        }
                        sb.append(pr.getKlass()).append(" \"").append(pr.getName()).append("\" ");
                    }
                    return sb.toString();
                }
                throw new PolicyUtils.ExpansionFailedException(Messages.getString("security.144"));
            }
            if ("alias".equals(protocol)) {
                try {
                    return this.pc2str(DefaultPolicyParser.this.getPrincipalByAlias(this.ks, data));
                }
                catch (Exception e) {
                    if (e instanceof SecurityException) {
                        throw (SecurityException)e;
                    }
                    throw new PolicyUtils.ExpansionFailedException(Messages.getString("security.143", data), e);
                }
            }
            throw new PolicyUtils.ExpansionFailedException(Messages.getString("security.145", protocol));
        }

        private String pc2str(Principal pc) {
            String klass = pc.getClass().getName();
            String name = pc.getName();
            StringBuilder sb = new StringBuilder(klass.length() + name.length() + 5);
            return sb.append(klass).append(" \"").append(name).append("\"").toString();
        }
    }
}

