/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.river.api.security.Messages;
import org.apache.river.api.security.Util;
import org.apache.river.impl.net.UriString;

class PolicyUtils {
    static final String POLICY_ALLOW_DYNAMIC = "policy.allowSystemProperty";
    static final String POLICY_EXPAND = "policy.expandProperties";
    static final String TRUE = "true";
    static final String FALSE = "false";
    private static final Class[] NO_ARGS = new Class[0];
    private static final Class[] ONE_ARGS = new Class[]{String.class};
    private static final Class[] TWO_ARGS = new Class[]{String.class, String.class};

    private PolicyUtils() {
    }

    public static String expand(String str, Properties properties) throws ExpansionFailedException {
        String START_MARK = "${";
        String END_MARK = "}";
        int START_OFFSET = "${".length();
        int END_OFFSET = "}".length();
        StringBuilder result = new StringBuilder(str);
        int start = result.indexOf("${");
        while (start >= 0) {
            int end = result.indexOf("}", start);
            if (end >= 0) {
                String key = result.substring(start + START_OFFSET, end);
                String value = properties.getProperty(key);
                if (value != null) {
                    result.replace(start, end + END_OFFSET, value);
                    start += value.length();
                } else {
                    throw new ExpansionFailedException(Messages.getString("security.14F", key));
                }
            }
            start = result.indexOf("${", start);
        }
        return result.toString();
    }

    static String expandURL(String str, Properties properties) throws ExpansionFailedException {
        return PolicyUtils.expand(str, properties).replace(File.separatorChar, '/');
    }

    static URI normalizeURL(URL codebase) throws URISyntaxException {
        block6: {
            if (codebase == null) {
                return null;
            }
            if ("file".equals(codebase.getProtocol())) {
                try {
                    if (codebase.getHost().length() == 0) {
                        String path = codebase.getFile();
                        if (path.length() == 0) {
                            path = "*";
                        }
                        return UriString.normalisation(PolicyUtils.filePathToURI(new File(path).getAbsolutePath()));
                    }
                    return UriString.normalisation(codebase.toURI());
                }
                catch (Exception e) {
                    if (!(e instanceof SecurityException)) break block6;
                    throw (SecurityException)e;
                }
            }
        }
        return UriString.normalisation(codebase.toURI());
    }

    static URI filePathToURI(String path) throws URISyntaxException {
        if (File.separatorChar == '\\' && path != null) {
            path = path.replace(File.separatorChar, '/');
            path = path.toUpperCase();
        }
        if (!path.startsWith("/")) {
            return new URI("file", null, new StringBuilder(path.length() + 1).append('/').append(path).toString(), null, null);
        }
        return new URI("file", null, path, null, null);
    }

    static String expandGeneral(String str, GeneralExpansionHandler handler) throws ExpansionFailedException {
        String START_MARK = "${{";
        String END_MARK = "}}";
        int START_OFFSET = "${{".length();
        int END_OFFSET = "}}".length();
        StringBuilder result = new StringBuilder(str);
        int start = result.indexOf("${{");
        while (start >= 0) {
            int end = result.indexOf("}}", start);
            if (end >= 0) {
                String key = result.substring(start + START_OFFSET, end);
                int separator = key.indexOf(58);
                String protocol = separator >= 0 ? key.substring(0, separator) : key;
                String data = separator >= 0 ? key.substring(separator + 1) : null;
                String value = handler.resolve(protocol, data);
                result.replace(start, end + END_OFFSET, value);
                start += value.length();
            }
            start = result.indexOf("${{", start);
        }
        return result.toString();
    }

    static boolean canExpandProperties() {
        return !Util.equalsIgnoreCase(FALSE, AccessController.doPrivileged(new SecurityPropertyAccessor(POLICY_EXPAND)));
    }

    static URL[] getPolicyURLs(Properties system, String systemUrlKey, String securityUrlPrefix) {
        String location;
        ArrayList<URL> urls = new ArrayList<URL>();
        boolean dynamicOnly = false;
        URL dynamicURL = null;
        if (!Util.equalsIgnoreCase(FALSE, Security.getProperty(POLICY_ALLOW_DYNAMIC)) && (location = system.getProperty(systemUrlKey)) != null) {
            if (location.startsWith("=")) {
                dynamicOnly = true;
                location = location.substring(1);
            }
            try {
                location = PolicyUtils.expandURL(location, system);
                File f = new File(location);
                if (f.exists()) {
                    dynamicURL = f.toURI().toURL();
                }
                if (dynamicURL == null) {
                    dynamicURL = new URL(location);
                }
            }
            catch (Exception e) {
                if (e instanceof SecurityException) {
                    throw (SecurityException)e;
                }
                System.err.println("Error detecting system policy location: " + e);
            }
        }
        if (!dynamicOnly) {
            String location2;
            int i = 1;
            while ((location2 = Security.getProperty(securityUrlPrefix + i++)) != null) {
                try {
                    URL anURL = new URL(location2 = PolicyUtils.expandURL(location2, system));
                    if (anURL == null) continue;
                    urls.add(anURL);
                }
                catch (Exception e) {
                    if (e instanceof SecurityException) {
                        throw (SecurityException)e;
                    }
                    System.err.println("Error detecting security policy location: " + e);
                }
            }
        }
        if (dynamicURL != null) {
            urls.add(dynamicURL);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    static PermissionCollection toPermissionCollection(Collection<Permission> perms) {
        Permissions pc = new Permissions();
        if (perms != null) {
            for (Permission element : perms) {
                ((PermissionCollection)pc).add(element);
            }
        }
        return pc;
    }

    static Permission instantiatePermission(Class<?> targetType, String targetName, String targetActions) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[][] argTypes = null;
        Object[][] args = null;
        if (targetActions != null) {
            argTypes = new Class[][]{TWO_ARGS, ONE_ARGS, NO_ARGS};
            args = new Object[][]{{targetName, targetActions}, {targetName}, new Object[0]};
        } else if (targetName != null) {
            argTypes = new Class[][]{ONE_ARGS, TWO_ARGS, NO_ARGS};
            args = new Object[][]{{targetName}, {targetName, targetActions}, new Object[0]};
        } else {
            argTypes = new Class[][]{NO_ARGS, ONE_ARGS, TWO_ARGS};
            args = new Object[][]{new Object[0], {targetName}, {targetName, targetActions}};
        }
        for (int i = 0; i < argTypes.length; ++i) {
            try {
                Constructor<?> ctor = targetType.getConstructor(argTypes[i]);
                return (Permission)ctor.newInstance(args[i]);
            }
            catch (NoSuchMethodException ignore) {
                continue;
            }
        }
        throw new IllegalArgumentException(Messages.getString("security.150", targetType));
    }

    public static boolean matchSubset(Object[] what, Object[] where) {
        if (what == null) {
            return true;
        }
        for (int i = 0; i < what.length; ++i) {
            if (what[i] == null) continue;
            if (where == null) {
                return false;
            }
            boolean found = false;
            for (int j = 0; j < where.length; ++j) {
                if (!what[i].equals(where[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    static interface GeneralExpansionHandler {
        public String resolve(String var1, String var2) throws ExpansionFailedException;
    }

    static class ExpansionFailedException
    extends Exception {
        private static final long serialVersionUID = 2869748055182612000L;

        ExpansionFailedException(String message) {
            super(message);
        }

        ExpansionFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    static class SecurityPropertyAccessor
    implements PrivilegedAction<String> {
        private String key;

        SecurityPropertyAccessor(String key) {
            this.key = key;
        }

        PrivilegedAction<String> key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public String run() {
            return Security.getProperty(this.key);
        }
    }

    static class URLLoader
    implements PrivilegedExceptionAction<InputStream> {
        private final URL location;

        URLLoader(URL location) {
            this.location = location;
        }

        @Override
        public InputStream run() throws IOException {
            return this.location.openStream();
        }
    }
}

