/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.io.IOException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Guard;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.security.GrantPermission;
import net.jini.security.policy.PolicyInitializationException;
import org.apache.river.api.security.AbstractPolicy;
import org.apache.river.api.security.CachingSecurityManager;
import org.apache.river.api.security.PermissionGrant;
import org.apache.river.api.security.PolicyPermission;
import org.apache.river.api.security.RemotePolicy;
import org.apache.river.api.security.ScalableNestedPolicy;

public class RemotePolicyProvider
extends AbstractPolicy
implements RemotePolicy,
ScalableNestedPolicy {
    private static final String basePolicyClassProperty = "org.apache.river.api.security.RemotePolicyProvider.basePolicyClass";
    private static final String defaultBasePolicyClass = "org.apache.river.api.security.ConcurrentPolicyFile";
    private static final Logger logger = Logger.getLogger("org.apache.river.api.security");
    private static final ProtectionDomain policyDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

        @Override
        public ProtectionDomain run() {
            return RemotePolicyProvider.class.getProtectionDomain();
        }
    });
    private volatile PermissionGrant[] remotePolicyGrants;
    private final Object grantLock;
    private final Permission remotePolicyPermission;
    private final Guard protectionDomainPermission;
    private final Policy basePolicy;
    private final boolean basePolicyIsRemote;
    private final boolean basePolicyIsConcurrent;
    private final PermissionCollection policyPermissions;

    public RemotePolicyProvider() throws PolicyInitializationException {
        String cname = Security.getProperty(basePolicyClassProperty);
        if (cname == null) {
            cname = defaultBasePolicyClass;
        }
        try {
            this.basePolicy = (Policy)Class.forName(cname).newInstance();
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PolicyInitializationException("unable to construct base policy", e);
        }
        this.remotePolicyGrants = new PermissionGrant[0];
        this.grantLock = new Object();
        this.remotePolicyPermission = new PolicyPermission("Remote");
        this.protectionDomainPermission = new RuntimePermission("getProtectionDomain");
        this.basePolicyIsRemote = this.basePolicy instanceof RemotePolicy;
        this.basePolicyIsConcurrent = this.basePolicy instanceof ScalableNestedPolicy;
        this.policyPermissions = this.basePolicy.getPermissions(policyDomain);
        this.policyPermissions.setReadOnly();
    }

    public RemotePolicyProvider(Policy basePolicy) {
        this.basePolicy = basePolicy;
        this.remotePolicyGrants = new PermissionGrant[0];
        this.grantLock = new Object();
        this.remotePolicyPermission = new PolicyPermission("Remote");
        this.protectionDomainPermission = new RuntimePermission("getProtectionDomain");
        this.basePolicyIsRemote = basePolicy instanceof RemotePolicy;
        this.basePolicyIsConcurrent = basePolicy instanceof ScalableNestedPolicy;
        this.policyPermissions = basePolicy.getPermissions(policyDomain);
        this.policyPermissions.setReadOnly();
    }

    @Override
    public void replace(PermissionGrant[] grants) throws IOException {
        try {
            this.processRemotePolicyGrants(grants);
        }
        catch (SecurityException ex) {
            ex.fillInStackTrace();
            logger.log(Level.WARNING, "Remote Policy update failed with SecurityException: ", ex);
        }
        catch (NullPointerException ex) {
            ex.fillInStackTrace();
            logger.log(Level.SEVERE, "Remote Policy update failed with NullPointerException: ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRemotePolicyGrants(PermissionGrant[] grants) {
        LinkedList<PermissionGrant> holder = new LinkedList<PermissionGrant>();
        this.remotePolicyPermission.checkGuard(null);
        this.protectionDomainPermission.checkGuard(null);
        Iterator gi = holder.iterator();
        int l = grants.length;
        for (int i = 0; i < l; ++i) {
            try {
                this.checkCallerHasGrants(grants[i]);
                holder.add(grants[i]);
                continue;
            }
            catch (SecurityException e) {
                logger.log(Level.WARNING, "Caller doesn't have necessary GrantPermission:\n ", grants[i]);
            }
        }
        Object i = this.grantLock;
        synchronized (i) {
            PermissionGrant[] updated = new PermissionGrant[holder.size()];
            this.remotePolicyGrants = holder.toArray(updated);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm instanceof CachingSecurityManager) {
            ((CachingSecurityManager)((Object)sm)).clearCache();
        }
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        return this.basePolicy.getPermissions(codesource);
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        Collection<PermissionGrant> grants = this.getPermissionGrants(domain);
        TreeSet<Permission> perms = new TreeSet<Permission>(this.comparator);
        this.processGrants(grants, null, true, perms);
        return this.convert(perms, perms.size(), 0.75f, 1, 16);
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        Class<?> permClass;
        if (domain == policyDomain) {
            return this.policyPermissions.implies(permission);
        }
        if (this.basePolicyIsRemote && this.basePolicy.implies(domain, permission)) {
            return true;
        }
        if (permission == null) {
            throw new NullPointerException("permission not allowed to be null");
        }
        TreeSet<Permission> permissions = new TreeSet<Permission>(this.comparator);
        Class<?> clazz = permClass = permission instanceof GrantPermission ? null : permission.getClass();
        if (!this.basePolicyIsConcurrent) {
            PermissionCollection pc = this.basePolicy.getPermissions(domain);
            Enumeration<Permission> enu = pc.elements();
            while (enu.hasMoreElements()) {
                Permission p = enu.nextElement();
                if (p instanceof AllPermission) {
                    return true;
                }
                if (permClass == null) {
                    permissions.add(p);
                    continue;
                }
                if (!permClass.isInstance(permission) && !(permission instanceof UnresolvedPermission)) continue;
                permissions.add(p);
            }
        } else {
            Collection<PermissionGrant> grants = ((ScalableNestedPolicy)((Object)this.basePolicy)).getPermissionGrants(domain);
            this.processGrants(grants, permClass, true, permissions);
            if (permissions.contains(this.ALL_PERMISSION)) {
                return true;
            }
        }
        PermissionGrant[] grantsRefCopy = this.remotePolicyGrants;
        int l = grantsRefCopy.length;
        for (int i = 0; i < l; ++i) {
            if (!grantsRefCopy[i].implies(domain)) continue;
            Collection<Permission> perms = grantsRefCopy[i].getPermissions();
            for (Permission p : perms) {
                if (permClass == null) {
                    permissions.add(p);
                    continue;
                }
                if (!permClass.isInstance(permission) && !(permission instanceof UnresolvedPermission)) continue;
                permissions.add(p);
            }
        }
        PermissionCollection pc = null;
        if (permClass != null) {
            pc = this.convert(permissions, 1, 0.75f, 1, 16);
        } else {
            pc = this.convert(permissions, 24, 0.75f, 1, 16);
            this.expandUmbrella(pc);
        }
        return pc.implies(permission);
    }

    @Override
    public Collection<PermissionGrant> getPermissionGrants(ProtectionDomain domain) {
        Collection<Object> grants = null;
        if (this.basePolicy instanceof ScalableNestedPolicy) {
            grants = ((ScalableNestedPolicy)((Object)this.basePolicy)).getPermissionGrants(domain);
        } else {
            grants = new LinkedList<PermissionGrant>();
            grants.add(this.extractGrantFromPolicy(this.basePolicy, domain));
        }
        PermissionGrant[] rpg = this.remotePolicyGrants;
        grants.addAll(Arrays.asList(rpg));
        return grants;
    }
}

