/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.util.Properties;
import org.apache.river.api.security.Messages;
import org.apache.river.api.security.PolicyUtils;

class Segment
implements Comparable {
    private Segment previous;
    private Segment[] divisions;
    private String original;
    int counter = 0;
    Status stat;
    private StringBuilder sb;
    private boolean toggle;

    public Segment(String s, Segment preceed) {
        this.previous = preceed;
        this.stat = Status.STRING;
        this.divisions = null;
        this.original = s;
        this.sb = null;
        this.toggle = false;
    }

    public String toString() {
        return this.original;
    }

    public Status status() {
        return this.stat;
    }

    public boolean hasNext() {
        if (this.allStringState()) {
            return true;
        }
        if (this.stat.equals((Object)Status.COMPLETE) || this.stat.equals((Object)Status.STRING)) {
            return this.previous == null ? false : this.previous.hasNext();
        }
        return true;
    }

    private boolean allStringState() {
        if (this.toggle) {
            return false;
        }
        this.toggle = true;
        return (this.previous == null || this.previous.allStringState()) && this.status().equals((Object)Status.STRING);
    }

    public String next() {
        if (this.sb == null) {
            this.sb = new StringBuilder(120);
        } else {
            this.sb.delete(0, this.sb.capacity() - 1);
        }
        this.append(this.sb);
        if (this.stat.equals((Object)Status.COMPLETE)) {
            if (this.previous != null) {
                this.previous.next();
            }
        } else if (this.stat.equals((Object)Status.MORE)) {
            if (this.divisions[this.counter].status().equals((Object)Status.MORE)) {
                this.divisions[this.counter].next();
            } else {
                ++this.counter;
            }
            if (this.counter == this.divisions.length) {
                this.stat = Status.COMPLETE;
            }
        } else if (this.stat.equals((Object)Status.STRING) && this.previous != null) {
            this.previous.next();
        }
        return this.sb.toString();
    }

    private StringBuilder append(StringBuilder sb) {
        if (this.previous != null) {
            this.previous.append(sb);
        }
        if (this.divisions != null) {
            this.divisions[this.counter].append(sb);
        } else {
            sb.append(this.original);
        }
        return sb;
    }

    private int sequenceNumber() {
        int sequence = 1;
        if (this.previous != null) {
            sequence += this.previous.sequenceNumber();
        }
        return sequence;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Segment)) {
            throw new ClassCastException(o.toString() + " not an instance of Segment");
        }
        Segment that = (Segment)o;
        if (this.sequenceNumber() == that.sequenceNumber()) {
            return 0;
        }
        if (this.sequenceNumber() < that.sequenceNumber()) {
            return -1;
        }
        return 1;
    }

    public void divideAndReplace(String START_MARK, String END_MARK, String regex, Properties p) throws PolicyUtils.ExpansionFailedException {
        if (this.previous != null) {
            this.previous.divideAndReplace(START_MARK, END_MARK, regex, p);
        }
        if (this.divisions != null) {
            int l = this.divisions.length;
            for (int i = 0; i < l; ++i) {
                this.divisions[i].divideAndReplace(START_MARK, END_MARK, regex, p);
            }
            return;
        }
        String orig = this.original;
        Segment prev = this.previous;
        int START_OFFSET = START_MARK.length();
        int END_OFFSET = END_MARK.length();
        int start = orig.indexOf(START_MARK);
        int end = 0;
        int beginning = 0;
        while (start >= 0) {
            Segment seg;
            if (start > beginning && beginning >= 0) {
                prev = seg = new Segment(orig.substring(beginning, start), prev);
            }
            if ((end = orig.indexOf(END_MARK, start)) >= 0) {
                String key = orig.substring(start + START_OFFSET, end);
                String value = p.getProperty(key);
                if (value != null) {
                    seg = new Segment(value, prev);
                    if (regex != null) {
                        seg.split(regex);
                        seg.status(Status.MORE);
                    }
                    prev = seg;
                } else {
                    throw new PolicyUtils.ExpansionFailedException(Messages.getString("security.14F", key));
                }
            }
            beginning = end + END_OFFSET;
            start = orig.indexOf(START_MARK, beginning);
        }
        if (beginning < orig.length()) {
            this.previous = prev;
            this.original = orig.substring(beginning);
        } else if (beginning == orig.length() && prev != null) {
            this.previous = prev.previous;
            this.original = prev.original;
            this.divisions = prev.divisions;
            this.stat = prev.stat;
        }
    }

    private void split(String regex) {
        String[] prop = this.original.split(regex);
        int l = prop.length;
        this.divisions = new Segment[l];
        for (int i = 0; i < l; ++i) {
            this.divisions[i] = new Segment(prop[i], null);
        }
    }

    private void status(Status status) {
        this.stat = status;
    }

    public static enum Status {
        STRING,
        MORE,
        COMPLETE;

    }
}

