/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf;

import java.io.PrintWriter;
import org.databene.contiperf.Clock;
import org.databene.contiperf.ExecutionConfig;
import org.databene.contiperf.Invoker;
import org.databene.contiperf.PercentileRequirement;
import org.databene.contiperf.PerformanceRequirement;
import org.databene.contiperf.clock.SystemClock;
import org.databene.contiperf.report.ReportContext;
import org.databene.contiperf.report.ReportModule;
import org.databene.contiperf.util.InvokerProxy;
import org.databene.stat.LatencyCounter;

public class PerformanceTracker
extends InvokerProxy {
    private final ExecutionConfig executionConfig;
    private final PerformanceRequirement requirement;
    private ReportContext context;
    private Clock[] clocks;
    private LatencyCounter[] counters;
    private boolean trackingStarted;
    private long warmUpFinishedTime;

    public PerformanceTracker(Invoker target, PerformanceRequirement requirement, ReportContext context) {
        this(target, null, requirement, context, new Clock[]{new SystemClock()});
    }

    public PerformanceTracker(Invoker target, ExecutionConfig executionConfig, PerformanceRequirement requirement, ReportContext context, Clock[] clocks) {
        super(target);
        this.executionConfig = executionConfig != null ? executionConfig : new ExecutionConfig(0);
        this.requirement = requirement;
        this.setContext(context);
        this.clocks = clocks;
        this.counters = null;
        this.trackingStarted = false;
        this.warmUpFinishedTime = -1L;
    }

    public void setContext(ReportContext context) {
        this.context = context;
    }

    public LatencyCounter[] getCounters() {
        return this.counters;
    }

    public void startTracking() {
        this.reportStart();
        int max = this.requirement != null ? this.requirement.getMax() : -1;
        this.counters = new LatencyCounter[this.clocks.length];
        for (int i = 0; i < this.clocks.length; ++i) {
            LatencyCounter counter;
            this.counters[i] = counter = new LatencyCounter(this.target.toString(), this.clocks[i].getName(), max >= 0 ? max : 1000);
            counter.start();
        }
        this.trackingStarted = true;
    }

    public Object invoke(Object[] args) throws Exception {
        long clock0StartTime = this.clocks[0].getTime();
        long realStartMillis = System.nanoTime() / 1000000L;
        if (this.warmUpFinishedTime == -1L) {
            this.warmUpFinishedTime = realStartMillis + (long)this.executionConfig.getWarmUp();
        }
        this.checkState(realStartMillis);
        Object result = super.invoke(args);
        int latency = (int)(this.clocks[0].getTime() - clock0StartTime);
        if (this.isTrackingStarted()) {
            for (LatencyCounter counter : this.counters) {
                counter.addSample(latency);
            }
        }
        this.reportInvocation(latency, realStartMillis);
        if (this.requirement != null && this.requirement.getMax() >= 0 && latency > this.requirement.getMax() && this.executionConfig.isCancelOnViolation()) {
            this.context.fail("Method " + this.getId() + " exceeded time limit of " + this.requirement.getMax() + " ms running " + latency + " ms");
        }
        return result;
    }

    private synchronized void checkState(long callStart) {
        if (callStart >= this.warmUpFinishedTime && !this.trackingStarted) {
            this.startTracking();
        }
    }

    public boolean isTrackingStarted() {
        return this.trackingStarted;
    }

    public void stopTracking() {
        if (!this.isTrackingStarted()) {
            throw new RuntimeException("Trying to stop counter before it was started");
        }
        for (LatencyCounter counter : this.counters) {
            counter.stop();
        }
        LatencyCounter mainCounter = this.counters[0];
        mainCounter.printSummary(new PrintWriter(System.out), new int[0]);
        this.reportCompletion();
        if (this.requirement != null) {
            this.checkRequirements(mainCounter.duration());
        }
        this.trackingStarted = false;
    }

    public void clear() {
        this.counters = null;
    }

    private void reportStart() {
        for (ReportModule module : this.context.getReportModules()) {
            module.starting(this.getId());
        }
    }

    private void reportInvocation(int latency, long callStart) {
        for (ReportModule module : this.context.getReportModules()) {
            module.invoked(this.getId(), latency, callStart);
        }
    }

    private void reportCompletion() {
        for (ReportModule module : this.context.getReportModules()) {
            module.completed(this.getId(), this.counters, this.executionConfig, this.requirement);
        }
    }

    private void checkRequirements(long elapsedMillis) {
        int requiredAverage;
        long actualThroughput;
        int requiredThroughput;
        long requiredTotalTime;
        long requiredMax = this.requirement.getMax();
        LatencyCounter mainCounter = this.counters[0];
        if (requiredMax >= 0L && mainCounter.maxLatency() > requiredMax) {
            this.context.fail("The maximum latency of " + requiredMax + " ms was exceeded, Measured: " + mainCounter.maxLatency() + " ms");
        }
        if ((requiredTotalTime = (long)this.requirement.getTotalTime()) >= 0L && elapsedMillis > requiredTotalTime) {
            this.context.fail("Test run " + this.getId() + " exceeded timeout of " + requiredTotalTime + " ms running " + elapsedMillis + " ms");
        }
        if ((requiredThroughput = this.requirement.getThroughput()) > 0 && elapsedMillis > 0L && (actualThroughput = mainCounter.sampleCount() * 1000L / elapsedMillis) < (long)requiredThroughput) {
            this.context.fail("Test " + this.getId() + " had a throughput of only " + actualThroughput + " calls per second, required: " + requiredThroughput + " calls per second");
        }
        if ((requiredAverage = this.requirement.getAverage()) >= 0 && mainCounter.averageLatency() > (double)requiredAverage) {
            this.context.fail("Average execution time of " + this.getId() + " exceeded the requirement of " + requiredAverage + " ms, measured " + mainCounter.averageLatency() + " ms");
        }
        for (PercentileRequirement percentile : this.requirement.getPercentileRequirements()) {
            long measuredLatency = mainCounter.percentileLatency(percentile.getPercentage());
            if (measuredLatency <= (long)percentile.getMillis()) continue;
            this.context.fail(percentile.getPercentage() + "-percentile of " + this.getId() + " exceeded the requirement of " + percentile.getMillis() + " ms, measured " + measuredLatency + " ms");
        }
    }
}

