/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.sensor;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;

public class MemorySensor {
    private static final int DEFAULT_INTERVAL = 60000;
    private static final MemorySensor INSTANCE = new MemorySensor();
    private MeasurementThread thread;
    private long maxUsedHeapSize;
    private long maxCommittedHeapSize;

    public static MemorySensor getInstance() {
        return INSTANCE;
    }

    public MemorySensor() {
        this.startThread(60000);
        this.reset();
    }

    public int getInterval() {
        return this.thread.getInterval();
    }

    public void setInterval(int interval) {
        if (interval != this.getInterval()) {
            this.thread.cancel();
            this.startThread(interval);
        }
    }

    public long getMaxUsedHeapSize() {
        return this.maxUsedHeapSize;
    }

    public long getMaxCommittedHeapSize() {
        return this.maxCommittedHeapSize;
    }

    public void reset() {
        this.maxUsedHeapSize = 0L;
        this.maxCommittedHeapSize = 0L;
        this.measure();
    }

    public void measure() {
        MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        this.maxUsedHeapSize = Math.max(this.maxUsedHeapSize, heapMemoryUsage.getUsed());
        this.maxCommittedHeapSize = Math.max(this.maxCommittedHeapSize, heapMemoryUsage.getCommitted());
    }

    private void startThread(int interval) {
        this.thread = new MeasurementThread(interval);
        this.thread.start();
    }

    class MeasurementThread
    extends Thread {
        private int interval;

        public MeasurementThread(int interval) {
            this.interval = interval;
            this.setDaemon(true);
        }

        public int getInterval() {
            return this.interval;
        }

        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    MemorySensor.this.measure();
                    Thread.sleep(this.interval);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void cancel() {
            this.interrupt();
        }
    }
}

