/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.CXFAuthenticator;
import org.apache.cxf.transport.http.ChunkedUtil;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.https.HttpsURLConnectionFactory;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class URLConnectionHTTPConduit
extends HTTPConduit {
    protected HttpsURLConnectionFactory connectionFactory = new HttpsURLConnectionFactory();

    public URLConnectionHTTPConduit(Bus b, EndpointInfo ei) throws IOException {
        super(b, ei);
        CXFAuthenticator.addAuthenticator();
    }

    public URLConnectionHTTPConduit(Bus b, EndpointInfo ei, EndpointReferenceType t) throws IOException {
        super(b, ei, t);
        CXFAuthenticator.addAuthenticator();
    }

    @Override
    public void close() {
        super.close();
        if (this.defaultEndpointURI != null) {
            try {
                URLConnection connect = this.defaultEndpointURI.toURL().openConnection();
                if (connect instanceof HttpURLConnection) {
                    ((HttpURLConnection)connect).disconnect();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private HttpURLConnection createConnection(Message message, URI uri, HTTPClientPolicy csPolicy) throws IOException {
        URL url = uri.toURL();
        Proxy proxy = this.proxyFactory.createProxy(csPolicy, uri);
        message.put((Object)"http.scheme", (Object)uri.getScheme());
        TLSClientParameters clientParameters = (TLSClientParameters)message.get(TLSClientParameters.class);
        if (clientParameters == null) {
            clientParameters = this.tlsClientParameters;
        }
        return this.connectionFactory.createConnection(clientParameters, proxy, url);
    }

    @Override
    protected void setupConnection(Message message, URI currentURL, HTTPClientPolicy csPolicy) throws IOException {
        HttpURLConnection connection = this.createConnection(message, currentURL, csPolicy);
        connection.setDoOutput(true);
        int ctimeout = URLConnectionHTTPConduit.determineConnectionTimeout(message, csPolicy);
        connection.setConnectTimeout(ctimeout);
        int rtimeout = URLConnectionHTTPConduit.determineReceiveTimeout(message, csPolicy);
        connection.setReadTimeout(rtimeout);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        String httpRequestMethod = (String)message.get((Object)"org.apache.cxf.request.method");
        if (httpRequestMethod == null) {
            httpRequestMethod = "POST";
            message.put((Object)"org.apache.cxf.request.method", (Object)"POST");
        }
        connection.setRequestMethod(httpRequestMethod);
        message.put((Object)"http.connection", (Object)connection);
    }

    @Override
    protected OutputStream createOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)message.get((Object)"http.connection");
        if (isChunking && chunkThreshold <= 0) {
            chunkThreshold = 0;
            connection.setChunkedStreamingMode(-1);
        }
        try {
            return new URLConnectionWrappedOutputStream(message, connection, needToCacheRequest, isChunking, chunkThreshold, this.getConduitName());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    class URLConnectionWrappedOutputStream
    extends HTTPConduit.WrappedOutputStream {
        HttpURLConnection connection;

        public URLConnectionWrappedOutputStream(Message message, HttpURLConnection connection, boolean needToCacheRequest, boolean isChunking, int chunkThreshold, String conduitName) throws URISyntaxException {
            super(URLConnectionHTTPConduit.this, message, needToCacheRequest, isChunking, chunkThreshold, conduitName, connection.getURL().toURI());
            this.connection = connection;
        }

        protected URLConnectionWrappedOutputStream(URLConnectionWrappedOutputStream wos) {
            super(URLConnectionHTTPConduit.this, wos);
            this.connection = wos.connection;
        }

        @Override
        protected void setupWrappedStream() throws IOException {
            OutputStream cout = null;
            try {
                cout = this.connection.getOutputStream();
            }
            catch (SocketException e) {
                if ("Socket Closed".equals(e.getMessage())) {
                    this.connection.connect();
                    cout = this.connection.getOutputStream();
                }
                throw e;
            }
            if (this.cachingForRetransmission) {
                this.cachedStream = new CacheAndWriteOutputStream(cout);
                this.wrappedStream = this.cachedStream;
            } else {
                this.wrappedStream = cout;
            }
        }

        public void thresholdReached() {
            if (this.chunking) {
                this.connection.setChunkedStreamingMode(URLConnectionHTTPConduit.this.getClient().getChunkLength());
            }
        }

        @Override
        protected void onFirstWrite() throws IOException {
            super.onFirstWrite();
            if (HTTPConduit.LOG.isLoggable(Level.FINE)) {
                HTTPConduit.LOG.fine("Sending " + this.connection.getRequestMethod() + " Message with Headers to " + this.url + " Conduit :" + this.conduitName + "\n");
            }
        }

        @Override
        protected void setProtocolHeaders() throws IOException {
            new Headers(this.outMessage).setProtocolHeadersInConnection(this.connection);
        }

        @Override
        protected HttpsURLConnectionInfo getHttpsURLConnectionInfo() throws IOException {
            this.connection.connect();
            return new HttpsURLConnectionInfo(this.connection);
        }

        @Override
        protected void updateResponseHeaders(Message inMessage) {
            Headers h = new Headers(inMessage);
            h.readFromConnection(this.connection);
            inMessage.put((Object)"Content-Type", (Object)this.connection.getContentType());
            URLConnectionHTTPConduit.this.cookies.readFromHeaders(h);
        }

        @Override
        protected void handleResponseAsync() throws IOException {
            this.handleResponseOnWorkqueue(true, false);
        }

        @Override
        protected void updateCookiesBeforeRetransmit() {
            Headers h = new Headers();
            h.readFromConnection(this.connection);
            URLConnectionHTTPConduit.this.cookies.readFromHeaders(h);
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            InputStream in = null;
            if (this.getResponseCode() >= 400) {
                in = this.connection.getErrorStream();
                if (in == null) {
                    try {
                        in = this.connection.getInputStream();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                in = this.connection.getInputStream();
            }
            return in;
        }

        @Override
        protected void closeInputStream() throws IOException {
            InputStream ins = this.connection.getErrorStream();
            if (ins == null) {
                ins = this.connection.getInputStream();
            }
            if (ins != null) {
                IOUtils.consume((InputStream)ins);
                ins.close();
            }
        }

        @Override
        protected int getResponseCode() throws IOException {
            return this.connection.getResponseCode();
        }

        @Override
        protected String getResponseMessage() throws IOException {
            return this.connection.getResponseMessage();
        }

        @Override
        protected InputStream getPartialResponse() throws IOException {
            return ChunkedUtil.getPartialResponse(this.connection, this.connection.getResponseCode());
        }

        @Override
        protected boolean usingProxy() {
            return this.connection.usingProxy();
        }

        @Override
        protected void setFixedLengthStreamingMode(int i) {
            this.connection.setFixedLengthStreamingMode(i);
        }

        @Override
        protected void setupNewConnection(String newURL) throws IOException {
            URI nurl;
            HTTPClientPolicy cp = URLConnectionHTTPConduit.this.getClient(this.outMessage);
            try {
                nurl = new URI(newURL);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            URLConnectionHTTPConduit.this.setupConnection(this.outMessage, nurl, cp);
            try {
                this.url = new URI(newURL);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            this.connection = (HttpURLConnection)this.outMessage.get((Object)"http.connection");
        }

        @Override
        protected void retransmitStream() throws IOException {
            OutputStream out = this.connection.getOutputStream();
            this.cachedStream.writeCacheTo(out);
        }
    }
}

