/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.json;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.jaxrs.provider.DataBindingProvider;
import org.apache.cxf.jaxrs.provider.json.utils.JSONUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.codehaus.jettison.mapped.Configuration;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DataBindingJSONProvider<T>
extends DataBindingProvider<T> {
    private List<String> arrayKeys;
    private boolean serializeAsArray;
    private ConcurrentHashMap<String, String> namespaceMap = new ConcurrentHashMap();
    private boolean writeXsiType = true;
    private boolean readXsiType = true;
    private boolean dropRootElement;
    private boolean ignoreMixedContent;
    private boolean ignoreNamespaces;

    public void setIgnoreNamespaces(boolean ignoreNamespaces) {
        this.ignoreNamespaces = ignoreNamespaces;
    }

    public void setDropRootElement(boolean dropRootElement) {
        this.dropRootElement = dropRootElement;
    }

    public void setWriteXsiType(boolean write) {
        this.writeXsiType = write;
    }

    public void setReadXsiType(boolean read) {
        this.readXsiType = read;
    }

    public void setArrayKeys(List<String> keys) {
        this.arrayKeys = keys;
    }

    public void setSerializeAsArray(boolean asArray) {
        this.serializeAsArray = asArray;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return true;
    }

    public void setNamespaceMap(Map<String, String> nsMap) {
        this.namespaceMap = new ConcurrentHashMap<String, String>(nsMap);
    }

    protected XMLStreamWriter createWriter(Class<?> type, Type genericType, String enc, OutputStream os) throws Exception {
        QName qname = null;
        qname = !InjectionUtils.isSupportedCollectionOrArray(type) ? this.getQName(type) : this.getQName(InjectionUtils.getActualType((Type)genericType));
        Configuration config = JSONUtils.createConfiguration(this.namespaceMap, this.writeXsiType && !this.ignoreNamespaces, false, null);
        XMLStreamWriter writer = JSONUtils.createStreamWriter(os, qname, this.writeXsiType && !this.ignoreNamespaces, config, this.serializeAsArray, this.arrayKeys, this.dropRootElement, enc);
        writer = JSONUtils.createIgnoreMixedContentWriterIfNeeded(writer, this.ignoreMixedContent);
        return JSONUtils.createIgnoreNsWriterIfNeeded(writer, this.ignoreNamespaces);
    }

    protected void writeToWriter(XMLStreamWriter writer, Object o) throws Exception {
        writer.writeStartDocument();
        super.writeToWriter(writer, o);
        writer.writeEndDocument();
    }

    protected XMLStreamReader createReader(Class<?> type, Type genericType, InputStream is) throws Exception {
        if (!InjectionUtils.isSupportedCollectionOrArray(type)) {
            this.getQName(type);
        } else {
            this.getQName(InjectionUtils.getActualType((Type)genericType));
        }
        return JSONUtils.createStreamReader(is, this.readXsiType, this.namespaceMap);
    }

    private QName getQName(Class<?> type) {
        QName qname = JAXRSUtils.getClassQName(type);
        this.namespaceMap.putIfAbsent(qname.getNamespaceURI(), "ns1");
        return qname;
    }

    public void setIgnoreMixedContent(boolean ignoreMixedContent) {
        this.ignoreMixedContent = ignoreMixedContent;
    }
}

