/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.Ref;
import au.net.zeus.collection.ReferenceMap;
import au.net.zeus.collection.ReferenceQueuingFactory;
import au.net.zeus.collection.Referrer;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceConcurrentMap<K, V>
extends ReferenceMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<Referrer<K>, Referrer<V>> map;

    ReferenceConcurrentMap(ConcurrentMap<Referrer<K>, Referrer<V>> map, Ref key, Ref val, boolean gcThreads, long gcKeyCycle, long gcValCycle) {
        super(map, key, val, gcThreads, gcKeyCycle, gcValCycle);
        this.map = map;
    }

    ReferenceConcurrentMap(ConcurrentMap<Referrer<K>, Referrer<V>> map, ReferenceQueuingFactory<K, Referrer<K>> krqf, ReferenceQueuingFactory<V, Referrer<V>> vrqf, Ref key, Ref val) {
        super(map, krqf, vrqf, key, val);
        this.map = map;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.processQueue();
        Referrer<K> k = this.wrapKey(key, true, false);
        Referrer<V> v = this.wrapVal(value, true, false);
        Referrer<V> val = this.map.putIfAbsent(k, v);
        while (val != null) {
            V existed = val.get();
            if (existed == null) {
                if (this.map.replace(k, val, v)) {
                    return null;
                }
                val = this.map.putIfAbsent(k, v);
                continue;
            }
            return existed;
        }
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.processQueue();
        return this.map.remove(this.wrapKey(key, false, true), this.wrapVal(value, false, true));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.processQueue();
        return this.map.replace(this.wrapKey(key, false, true), this.wrapVal(oldValue, false, true), this.wrapVal(newValue, true, false));
    }

    @Override
    public V replace(K key, V value) {
        this.processQueue();
        Referrer<V> val = this.map.replace(this.wrapKey(key, false, true), this.wrapVal(value, true, false));
        if (val != null) {
            return val.get();
        }
        return null;
    }
}

