/*
 * Decompiled with CFR 0.152.
 */
package com.artima.lookup.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class ConsistentSet
extends AbstractSet
implements Serializable {
    private static final long serialVersionUID = -533615203387369436L;
    private Object[] elements;

    public ConsistentSet() {
        this.elements = new Object[0];
    }

    public ConsistentSet(Collection init) {
        if (init == null) {
            throw new NullPointerException();
        }
        HashSet tempSet = new HashSet(init);
        this.elements = new Object[tempSet.size()];
        Iterator it = tempSet.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.elements[i] = it.next();
            ++i;
        }
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private int nextPos = 0;

            @Override
            public boolean hasNext() {
                return this.nextPos < ConsistentSet.this.elements.length;
            }

            public Object next() {
                Object next = ConsistentSet.this.elements[this.nextPos];
                ++this.nextPos;
                return next;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException();
            }
        };
    }

    @Override
    public int size() {
        return this.elements.length;
    }
}

