/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.DatagramBufferFactory;
import com.sun.jini.discovery.DelayedMulticastRequestDecoder;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastAnnouncementEncoder;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.internal.Plaintext;
import com.sun.jini.discovery.internal.X500Constraints;
import com.sun.jini.discovery.internal.X500Provider;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;

public class X500Server
extends X500Provider
implements DelayedMulticastRequestDecoder,
MulticastAnnouncementEncoder {
    protected X500Server(String formatName, String signatureAlgorithm, int maxSignatureLength, String keyAlgorithm, String keyAlgorithmOID) {
        super(formatName, signatureAlgorithm, maxSignatureLength, keyAlgorithm, keyAlgorithmOID);
    }

    @Override
    public MulticastRequest decodeMulticastRequest(ByteBuffer buf, InvocationConstraints constraints, ClientSubjectChecker checker, boolean delayConstraintCheck) throws IOException {
        try {
            int len = buf.getInt();
            ByteBuffer data = buf.duplicate();
            data.limit(data.position() + len);
            buf.position(data.limit());
            X500Principal p = new X500Principal(Plaintext.getUtf(buf));
            ByteBuffer signed = (ByteBuffer)data.duplicate().position(0);
            MulticastRequest mr = Plaintext.decodeMulticastRequest(data);
            mr = new X500MulticastRequest(mr, constraints, p, buf.duplicate(), signed, checker);
            if (!delayConstraintCheck) {
                mr.checkConstraints();
            }
            return mr;
        }
        catch (IOException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DiscoveryProtocolException(null, e);
        }
    }

    @Override
    public void encodeMulticastAnnouncement(MulticastAnnouncement announcement, DatagramBufferFactory bufs, InvocationConstraints constraints) throws IOException {
        if (announcement == null || bufs == null) {
            throw new NullPointerException();
        }
        try {
            X500Constraints cons = X500Constraints.process(constraints, false);
            X500PrivateCredential[] creds = this.getPrivateCredentials();
            X500PrivateCredential chosen = null;
            int best = -1;
            SecurityException se = null;
            for (int i = 0; i < creds.length; ++i) {
                X500PrivateCredential c = creds[i];
                X500Principal p = c.getCertificate().getSubjectX500Principal();
                int score = cons.checkServerPrincipal(p);
                if (score < 0) {
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.FINEST, "skipping disallowed principal {0}", new Object[]{p});
                    continue;
                }
                try {
                    this.checkAuthenticationPermission(p, "accept");
                }
                catch (SecurityException e) {
                    se = e;
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "not authorized to use principal {0}", new Object[]{p});
                    continue;
                }
                if (score <= best) continue;
                chosen = c;
                best = score;
            }
            if (chosen == null) {
                UnsupportedConstraintException uce = new UnsupportedConstraintException("unsupported constraints: " + constraints);
                if (se != null) {
                    X500Server.secureThrow(se, uce);
                }
                throw uce;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "using principal {0}", new Object[]{chosen});
            }
            X500Provider.SigningBufferFactory sbf = new X500Provider.SigningBufferFactory(bufs, chosen);
            Plaintext.encodeMulticastAnnouncement(announcement, sbf);
            sbf.sign();
        }
        catch (IOException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DiscoveryProtocolException(null, e);
        }
    }

    @Override
    public MulticastRequest decodeMulticastRequest(ByteBuffer buf, InvocationConstraints constraints, ClientSubjectChecker checker) throws IOException {
        return this.decodeMulticastRequest(buf, constraints, checker, false);
    }

    private class X500MulticastRequest
    extends MulticastRequest {
        private final InvocationConstraints constraints;
        private final X500Principal p;
        private final ByteBuffer signature;
        private final ByteBuffer signed;
        private final ClientSubjectChecker checker;

        private X500MulticastRequest(MulticastRequest plainMR, InvocationConstraints constraints, X500Principal p, ByteBuffer signature, ByteBuffer signed, ClientSubjectChecker checker) {
            super(plainMR.getHost(), plainMR.getPort(), plainMR.getGroups(), plainMR.getServiceIDs());
            this.constraints = constraints;
            this.p = p;
            this.signature = signature;
            this.signed = signed;
            this.checker = checker;
        }

        @Override
        public void checkConstraints() throws IOException {
            try {
                X500Constraints cons = X500Constraints.process(this.constraints, true);
                if (cons.checkClientPrincipal(this.p) < 0) {
                    throw new UnsupportedConstraintException("principal not allowed: " + this.p);
                }
                Certificate cert = X500Server.this.getCertificate(this.p);
                if (cert == null) {
                    throw new DiscoveryProtocolException("unknown principal: " + this.p);
                }
                if (X500Provider.logger.isLoggable(Level.FINEST)) {
                    X500Provider.logger.log(Level.FINEST, "mapped principal {0} to {1}", new Object[]{this.p, cert});
                }
                if (this.checker != null) {
                    this.checker.checkClientSubject(new Subject(true, Collections.singleton(this.p), Collections.singleton(cert), Collections.EMPTY_SET));
                }
                if (!X500Server.this.verify(this.signed.duplicate(), this.signature.duplicate(), cert.getPublicKey())) {
                    throw new DiscoveryProtocolException("signature verification failed: " + this.p);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DiscoveryProtocolException(null, e);
            }
        }
    }
}

