/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.ssl;

import com.sun.jini.discovery.UnicastDiscoveryClient;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.EndpointBasedClient;
import com.sun.jini.discovery.internal.EndpointInternals;
import com.sun.jini.discovery.internal.SslEndpointInternalsAccess;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import javax.net.SocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.ssl.SslEndpoint;

public class Client
implements UnicastDiscoveryClient {
    private final ClientImpl impl = new ClientImpl();

    @Override
    public String getFormatName() {
        return this.impl.getFormatName();
    }

    @Override
    public void checkUnicastDiscoveryConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        this.impl.checkUnicastDiscoveryConstraints(constraints);
    }

    @Override
    public UnicastResponse doUnicastDiscovery(Socket socket, InvocationConstraints constraints, ClassLoader defaultLoader, ClassLoader verifierLoader, Collection context, ByteBuffer sent, ByteBuffer received) throws IOException, ClassNotFoundException {
        return this.impl.doUnicastDiscovery(socket, constraints, defaultLoader, verifierLoader, context, sent, received);
    }

    private static final class ClientImpl
    extends EndpointBasedClient {
        private static EndpointInternals epi = (EndpointInternals)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SslEndpointInternalsAccess.get();
            }
        });

        ClientImpl() {
            super("net.jini.discovery.ssl", epi);
        }

        @Override
        protected Endpoint getEndpoint(SocketFactory factory, InvocationConstraints constraints) throws UnsupportedConstraintException {
            return SslEndpoint.getInstance("ignored", 1, factory);
        }
    }
}

