/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.fiddler;

import com.sun.jini.fiddler.Fiddler;
import com.sun.jini.fiddler.FiddlerLease;
import com.sun.jini.fiddler.FiddlerProxy;
import com.sun.jini.fiddler.ProxyUtil;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import com.sun.jini.proxy.ThrowThis;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.event.EventRegistration;
import net.jini.core.lease.Lease;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.LookupDiscoveryRegistration;
import net.jini.discovery.LookupUnmarshalException;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class FiddlerRegistration
implements LookupDiscoveryRegistration,
ReferentUuid,
Serializable {
    private static final long serialVersionUID = 2L;
    final Fiddler server;
    final Uuid registrationID;
    final EventRegistration eventReg;

    public static FiddlerRegistration createRegistration(Fiddler server, Uuid registrationID, EventRegistration eventReg) {
        if (server instanceof RemoteMethodControl) {
            return new ConstrainableFiddlerRegistration(server, registrationID, eventReg, null);
        }
        return new FiddlerRegistration(server, registrationID, eventReg);
    }

    private FiddlerRegistration(Fiddler server, Uuid registrationID, EventRegistration eventReg) {
        this.server = server;
        this.registrationID = registrationID;
        this.eventReg = eventReg;
    }

    @Override
    public EventRegistration getEventRegistration() {
        return this.eventReg;
    }

    @Override
    public Lease getLease() {
        return this.eventReg.getLease();
    }

    @Override
    public ServiceRegistrar[] getRegistrars() throws LookupUnmarshalException, RemoteException {
        MarshalledObject[] mRegs = null;
        try {
            mRegs = this.server.getRegistrars(this.registrationID);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
        }
        if (mRegs == null) {
            return null;
        }
        ServiceRegistrar[] regs = new ServiceRegistrar[mRegs.length];
        if (regs.length > 0) {
            ArrayList<MarshalledObject> marshalledRegs = new ArrayList<MarshalledObject>();
            for (int i = 0; i < mRegs.length; ++i) {
                marshalledRegs.add(mRegs[i]);
            }
            ArrayList unmarshalledRegs = new ArrayList();
            ArrayList exceptions = FiddlerRegistration.unmarshalRegistrars(marshalledRegs, unmarshalledRegs);
            FiddlerRegistration.insertRegistrars(regs, unmarshalledRegs);
            if (exceptions.size() > 0) {
                throw new LookupUnmarshalException(unmarshalledRegs.toArray(new ServiceRegistrar[unmarshalledRegs.size()]), marshalledRegs.toArray(new MarshalledObject[marshalledRegs.size()]), exceptions.toArray(new Throwable[exceptions.size()]), "failed to unmarshal at least one ServiceRegistrar");
            }
        } else {
            return regs;
        }
        HashSet<ServiceRegistrar> regsCopy = new HashSet<ServiceRegistrar>();
        for (int i = 0; i < regs.length; ++i) {
            if (regs[i] == null) continue;
            regsCopy.add(regs[i]);
        }
        return regsCopy.toArray(new ServiceRegistrar[regsCopy.size()]);
    }

    @Override
    public String[] getGroups() throws RemoteException {
        try {
            return this.server.getGroups(this.registrationID);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
            return new String[0];
        }
    }

    @Override
    public LookupLocator[] getLocators() throws RemoteException {
        try {
            return this.server.getLocators(this.registrationID);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
            return null;
        }
    }

    @Override
    public void addGroups(String[] groups) throws RemoteException {
        try {
            this.server.addGroups(this.registrationID, groups);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
        }
    }

    @Override
    public void setGroups(String[] groups) throws RemoteException {
        try {
            this.server.setGroups(this.registrationID, groups);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
        }
    }

    @Override
    public void removeGroups(String[] groups) throws RemoteException {
        try {
            this.server.removeGroups(this.registrationID, groups);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
        }
    }

    @Override
    public void addLocators(LookupLocator[] locators) throws RemoteException {
        try {
            this.server.addLocators(this.registrationID, locators);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
        }
    }

    @Override
    public void setLocators(LookupLocator[] locators) throws RemoteException {
        try {
            this.server.setLocators(this.registrationID, locators);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
        }
    }

    @Override
    public void removeLocators(LookupLocator[] locators) throws RemoteException {
        try {
            this.server.removeLocators(this.registrationID, locators);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
        }
    }

    @Override
    public void discard(ServiceRegistrar registrar) throws RemoteException {
        try {
            this.server.discard(this.registrationID, registrar);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
        }
    }

    @Override
    public Uuid getReferentUuid() {
        return this.registrationID;
    }

    public int hashCode() {
        return this.registrationID.hashCode();
    }

    public boolean equals(Object obj) {
        return ReferentUuids.compare(this, obj);
    }

    private static ArrayList unmarshalRegistrars(ArrayList marshalledRegs, ArrayList unmarshalledRegs) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        int i = 0;
        int nMarshalledRegs = marshalledRegs.size();
        for (int n = 0; n < nMarshalledRegs; ++n) {
            try {
                MarshalledObject marshalledObj = (MarshalledObject)marshalledRegs.get(i);
                ServiceRegistrar reg = (ServiceRegistrar)marshalledObj.get();
                unmarshalledRegs.add(reg);
                marshalledRegs.remove(i);
                continue;
            }
            catch (IOException e) {
                exceptions.add(e);
                ++i;
                continue;
            }
            catch (ClassNotFoundException e) {
                exceptions.add(e);
                ++i;
            }
        }
        return exceptions;
    }

    private static void insertRegistrars(ServiceRegistrar[] regsArray, ArrayList regsList) {
        if (regsArray != null && regsList != null) {
            int lenA = regsArray.length;
            int lenB = regsList.size();
            if (lenA == 0 || lenB == 0) {
                return;
            }
            int beg = FiddlerRegistration.indexFirstNull(regsArray);
            int end = beg + lenB <= lenA ? beg + lenB : lenA;
            int i = beg;
            int j = 0;
            while (i < end) {
                regsArray[i] = (ServiceRegistrar)regsList.get(j);
                ++i;
                ++j;
            }
        }
    }

    private static int indexFirstNull(Object[] arr) {
        int i = -1;
        if (arr == null || arr.length == 0) {
            return i;
        }
        for (i = 0; i < arr.length; ++i) {
            if (arr[i] != null) continue;
            return i;
        }
        return i;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.server == null) {
            throw new InvalidObjectException("FiddlerRegistration.readObject failure - server field is null");
        }
        if (this.registrationID == null) {
            throw new InvalidObjectException("FiddlerRegistration.readObject failure - registrationID field is null");
        }
        if (this.eventReg == null) {
            throw new InvalidObjectException("FiddlerRegistration.readObject failure - eventReg field is null");
        }
        if (!EventRegistration.class.equals(this.eventReg.getClass())) {
            throw new InvalidObjectException("ConstrainableFiddlerRegistration.readObject failure - eventReg class is not EventRegistration");
        }
        Object source = this.eventReg.getSource();
        if (source == null) {
            throw new InvalidObjectException("FiddlerRegistration.readObject failure - eventReg source is null");
        }
        if (!(source instanceof FiddlerProxy)) {
            throw new InvalidObjectException("FiddlerRegistration.readObject failure - eventReg source is not an instance of FiddlerProxy");
        }
        Lease lease = this.eventReg.getLease();
        if (!(lease instanceof FiddlerLease)) {
            throw new InvalidObjectException("FiddlerRegistration.readObject failure - eventReg lease is not an instance of FiddlerLease");
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data found when attempting to deserialize FiddlerRegistration instance");
    }

    static final class ConstrainableFiddlerRegistration
    extends FiddlerRegistration
    implements RemoteMethodControl {
        static final long serialVersionUID = 2L;
        private static final Method[] methodMapArray = new Method[]{ProxyUtil.getMethod(LookupDiscoveryRegistration.class, "getRegistrars", new Class[0]), ProxyUtil.getMethod(Fiddler.class, "getRegistrars", new Class[]{Uuid.class}), ProxyUtil.getMethod(LookupDiscoveryRegistration.class, "getGroups", new Class[0]), ProxyUtil.getMethod(Fiddler.class, "getGroups", new Class[]{Uuid.class}), ProxyUtil.getMethod(LookupDiscoveryRegistration.class, "getLocators", new Class[0]), ProxyUtil.getMethod(Fiddler.class, "getLocators", new Class[]{Uuid.class}), ProxyUtil.getMethod(LookupDiscoveryRegistration.class, "addGroups", new Class[]{String[].class}), ProxyUtil.getMethod(Fiddler.class, "addGroups", new Class[]{Uuid.class, String[].class}), ProxyUtil.getMethod(LookupDiscoveryRegistration.class, "setGroups", new Class[]{String[].class}), ProxyUtil.getMethod(Fiddler.class, "setGroups", new Class[]{Uuid.class, String[].class}), ProxyUtil.getMethod(LookupDiscoveryRegistration.class, "removeGroups", new Class[]{String[].class}), ProxyUtil.getMethod(Fiddler.class, "removeGroups", new Class[]{Uuid.class, String[].class}), ProxyUtil.getMethod(LookupDiscoveryRegistration.class, "addLocators", new Class[]{LookupLocator[].class}), ProxyUtil.getMethod(Fiddler.class, "addLocators", new Class[]{Uuid.class, LookupLocator[].class}), ProxyUtil.getMethod(LookupDiscoveryRegistration.class, "setLocators", new Class[]{LookupLocator[].class}), ProxyUtil.getMethod(Fiddler.class, "setLocators", new Class[]{Uuid.class, LookupLocator[].class}), ProxyUtil.getMethod(LookupDiscoveryRegistration.class, "removeLocators", new Class[]{LookupLocator[].class}), ProxyUtil.getMethod(Fiddler.class, "removeLocators", new Class[]{Uuid.class, LookupLocator[].class}), ProxyUtil.getMethod(LookupDiscoveryRegistration.class, "discard", new Class[]{ServiceRegistrar.class}), ProxyUtil.getMethod(Fiddler.class, "discard", new Class[]{Uuid.class, ServiceRegistrar.class})};
        private MethodConstraints methodConstraints;

        private ConstrainableFiddlerRegistration(Fiddler server, Uuid registrationID, EventRegistration eventReg, MethodConstraints methodConstraints) {
            super(ConstrainableFiddlerRegistration.constrainServer(server, methodConstraints), registrationID, eventReg);
            this.methodConstraints = methodConstraints;
        }

        private static Fiddler constrainServer(Fiddler server, MethodConstraints constraints) {
            MethodConstraints newConstraints = ConstrainableProxyUtil.translateConstraints(constraints, methodMapArray);
            RemoteMethodControl constrainedServer = ((RemoteMethodControl)((Object)server)).setConstraints(newConstraints);
            return (Fiddler)((Object)constrainedServer);
        }

        @Override
        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableFiddlerRegistration(this.server, this.registrationID, this.eventReg, constraints);
        }

        @Override
        public MethodConstraints getConstraints() {
            return this.methodConstraints;
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator(this.server);
        }

        @Override
        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            ConstrainableProxyUtil.verifyConsistentConstraints(this.methodConstraints, this.server, methodMapArray);
            Object source = this.eventReg.getSource();
            if (!(source instanceof FiddlerProxy.ConstrainableFiddlerProxy)) {
                throw new InvalidObjectException("ConstrainableFiddlerRegistration.readObject failure - eventReg source is not an instance  of ConstrainableFiddlerProxy");
            }
            Lease lease = this.eventReg.getLease();
            if (!(lease instanceof FiddlerLease.ConstrainableFiddlerLease)) {
                throw new InvalidObjectException("ConstrainableFiddlerRegistration.readObject failure - eventReg lease is not an instance  of ConstrainableFiddlerLease");
            }
        }
    }
}

