/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.jeri.internal.runtime.Target;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.jini.id.Uuid;

class Lease {
    private final Uuid clientID;
    private final Set<Target> notifySet = new HashSet<Target>(3);
    private long expiration;
    private volatile boolean lockForRemoval;

    Lease(Uuid clientID, long duration) {
        this.clientID = clientID;
        this.expiration = System.currentTimeMillis() + duration;
        this.lockForRemoval = false;
    }

    Uuid getClientID() {
        return this.clientID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean renew(long duration) {
        Lease lease = this;
        synchronized (lease) {
            if (this.lockForRemoval) {
                return false;
            }
            long newExpiration = System.currentTimeMillis() + duration;
            if (newExpiration > this.expiration) {
                this.expiration = newExpiration;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean notifyIfExpired(long now) {
        boolean expired = false;
        Lease lease = this;
        synchronized (lease) {
            boolean bl = expired = this.expiration < now;
            if (expired) {
                this.lockForRemoval = true;
                Iterator<Target> i = this.notifySet.iterator();
                while (i.hasNext()) {
                    Target t = i.next();
                    t.leaseExpired(this.clientID);
                    i.remove();
                }
            }
        }
        return expired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Target target) {
        Lease lease = this;
        synchronized (lease) {
            this.notifySet.remove(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(Target target) {
        Lease lease = this;
        synchronized (lease) {
            if (this.lockForRemoval) {
                return false;
            }
            this.notifySet.add(target);
            return true;
        }
    }
}

