/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mercury;

import com.sun.jini.mercury.EventLog;
import com.sun.jini.mercury.EventLogIterator;
import com.sun.jini.mercury.InternalMailboxException;
import com.sun.jini.mercury.PersistentEventLog;
import com.sun.jini.mercury.RemoteEventData;
import com.sun.jini.mercury.TransientEventLog;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import net.jini.core.event.RemoteEvent;
import net.jini.id.Uuid;

class EventLogFactory {
    private HashMap iterators = new HashMap();

    EventLogFactory() {
    }

    public EventLogIterator iterator(Uuid uuid, File logPath) {
        EventLogIteratorImpl eli = (EventLogIteratorImpl)this.iterators.get(uuid);
        if (eli == null) {
            eli = new EventLogIteratorImpl(uuid, logPath);
            try {
                eli.init();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.iterators.put(uuid, eli);
        }
        return eli;
    }

    public EventLogIterator iterator(Uuid uuid) {
        EventLogIteratorImpl eli = (EventLogIteratorImpl)this.iterators.get(uuid);
        if (eli == null) {
            eli = new EventLogIteratorImpl(uuid);
            try {
                eli.init();
            }
            catch (IOException ioe) {
                throw new InternalMailboxException("Received unexpected IOException from a non-persistent log", ioe);
            }
            this.iterators.put(uuid, eli);
        }
        return eli;
    }

    public void remove(Uuid uuid) {
        this.iterators.remove(uuid);
    }

    private static class EventLogIteratorImpl
    implements EventLogIterator {
        private final Uuid uuid;
        private EventLog log = null;

        EventLogIteratorImpl(Uuid id, File logPath) {
            this.uuid = id;
            this.log = new PersistentEventLog(id, logPath);
        }

        EventLogIteratorImpl(Uuid id) {
            this.uuid = id;
            this.log = new TransientEventLog(id);
        }

        public void init() throws IOException {
            this.log.init();
        }

        @Override
        public void add(RemoteEvent evt) throws IOException, IllegalArgumentException {
            this.log.add(evt);
        }

        @Override
        public boolean hasNext() throws IOException {
            return !this.log.isEmpty();
        }

        @Override
        public RemoteEvent next() throws IOException, ClassNotFoundException, NoSuchElementException {
            return this.log.next();
        }

        @Override
        public void remove() throws IOException, IllegalStateException {
            this.log.remove();
        }

        @Override
        public RemoteEventData[] readAhead(int maxEvents) throws IOException, ClassNotFoundException {
            return this.log.readAhead(maxEvents);
        }

        @Override
        public void moveAhead(Object cookie) throws IOException {
            this.log.moveAhead(cookie);
        }

        @Override
        public void destroy() throws IOException {
            this.log.close();
            this.log.delete();
        }
    }
}

