/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryHandle;
import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.SingletonQueryWatcher;
import com.sun.jini.outrigger.Transactable;
import com.sun.jini.outrigger.TransactableMgr;
import com.sun.jini.outrigger.Txn;
import java.util.WeakHashMap;
import net.jini.core.transaction.TransactionException;
import net.jini.space.InternalSpaceException;

class ConsumingWatcher
extends SingletonQueryWatcher
implements Transactable {
    private final Txn txn;
    private final boolean takeIt;
    private final WeakHashMap provisionallyRemovedEntrySet;

    ConsumingWatcher(long expiration, long timestamp, long startOrdinal, WeakHashMap provisionallyRemovedEntrySet, Txn txn, boolean takeIt) {
        super(expiration, timestamp, startOrdinal);
        this.txn = txn;
        this.takeIt = takeIt;
        this.provisionallyRemovedEntrySet = provisionallyRemovedEntrySet;
    }

    @Override
    boolean isInterested(EntryTransition transition, long ordinal) {
        TransactableMgr transitionTxn = transition.getTxn();
        return ordinal > this.startOrdinal && !this.isResolved() && transition.isAvailable() && (null == transitionTxn || this.txn == transitionTxn);
    }

    @Override
    synchronized void process(EntryTransition transition, long now) {
        if (this.isResolved()) {
            return;
        }
        EntryHandle handle = transition.getHandle();
        if (this.getServer().attemptCapture(handle, this.txn, this.takeIt, null, this.provisionallyRemovedEntrySet, now, this)) {
            this.resolve(handle, null);
        }
    }

    @Override
    synchronized boolean catchUp(EntryTransition transition, long now) {
        if (this.isResolved()) {
            return true;
        }
        TransactableMgr transitionTxn = transition.getTxn();
        EntryHandle handle = transition.getHandle();
        if (transition.isAvailable() && (null == transitionTxn || this.txn == transitionTxn) && this.getServer().attemptCapture(handle, this.txn, this.takeIt, null, this.provisionallyRemovedEntrySet, now, this)) {
            this.resolve(handle, null);
            return true;
        }
        return false;
    }

    @Override
    public synchronized int prepare(TransactableMgr mgr, OutriggerServerImpl space) {
        assert (this.txn != null) : "Transactable method called on a non-transactional ConsumingWatcher";
        if (!this.isResolved()) {
            this.resolve(null, new TransactionException("completed while operation in progress"));
        }
        return 4;
    }

    @Override
    public void commit(TransactableMgr mgr, OutriggerServerImpl space) {
        throw new InternalSpaceException("committing a blocking query");
    }

    @Override
    public void abort(TransactableMgr mgr, OutriggerServerImpl space) {
        this.prepare(mgr, space);
    }
}

