/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryHandle;
import com.sun.jini.outrigger.EntryHandleTmplDesc;
import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.FastList;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.RepEnum;
import com.sun.jini.outrigger.TransactableMgr;
import com.sun.jini.outrigger.Txn;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.server.TransactionConstants;

class EntryHolder
implements TransactionConstants {
    private final FastList<EntryHandle> contents = new FastList();
    private final Hashtable idMap;
    private final OutriggerServerImpl space;
    private static final Logger matchingLogger = Logger.getLogger("com.sun.jini.outrigger.entryMatching");
    private static final Logger iteratorLogger = Logger.getLogger("com.sun.jini.outrigger.iterator");

    EntryHolder(OutriggerServerImpl space, Hashtable idMap) {
        this.space = space;
        this.idMap = idMap;
    }

    EntryHandle hasMatch(EntryRep tmpl, TransactableMgr txn, boolean takeIt, Set conflictSet, Set lockedEntrySet, WeakHashMap provisionallyRemovedEntrySet) throws CannotJoinException {
        matchingLogger.entering("EntryHolder", "hasMatch");
        EntryHandleTmplDesc desc = null;
        long startTime = 0L;
        for (EntryHandle handle : this.contents) {
            boolean available;
            EntryRep rep;
            if (startTime == 0L) {
                desc = EntryHandle.descFor(tmpl, handle.rep().numFields());
                startTime = System.currentTimeMillis();
            }
            if (handle.removed() || (handle.hash() & desc.mask) != desc.hash || !tmpl.matches(rep = handle.rep()) || !(available = this.confirmAvailabilityWithTxn(rep, handle, txn, takeIt, startTime, conflictSet, lockedEntrySet, provisionallyRemovedEntrySet))) continue;
            return handle;
        }
        return null;
    }

    void dump(String name) {
        try {
            System.out.println(name);
            for (EntryHandle handle : this.contents) {
                EntryRep rep = handle.rep();
                System.out.println("    " + rep + ", " + rep.entry());
            }
        }
        catch (UnusableEntryException e) {
            e.printStackTrace();
        }
    }

    boolean attemptCapture(EntryHandle handle, TransactableMgr txn, boolean takeIt, Set conflictSet, Set lockedEntrySet, WeakHashMap provisionallyRemovedEntrySet, long now) {
        try {
            return this.confirmAvailabilityWithTxn(handle.rep(), handle, txn, takeIt, now, conflictSet, lockedEntrySet, provisionallyRemovedEntrySet);
        }
        catch (CannotJoinException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean confirmAvailabilityWithTxn(EntryRep rep, EntryHandle handle, TransactableMgr txnMgr, boolean takeIt, long time, Set conflictSet, Set lockedEntrySet, WeakHashMap provisionallyRemovedEntrySet) throws CannotJoinException {
        Txn txn = (Txn)txnMgr;
        try {
            if (txn != null) {
                txn.ensureActive();
            }
            boolean bl = this.confirmAvailability(rep, handle, txn, takeIt, time, conflictSet, lockedEntrySet, provisionallyRemovedEntrySet);
            return bl;
        }
        finally {
            if (txn != null) {
                txn.allowStateChange();
            }
        }
    }

    private boolean confirmAvailability(EntryRep rep, EntryHandle handle, TransactableMgr txn, boolean takeIt, long time, Set conflictSet, Set lockedEntrySet, WeakHashMap provisionallyRemovedEntrySet) {
        if (handle.removed()) {
            return false;
        }
        EntryHandle entryHandle = handle;
        synchronized (entryHandle) {
            int op;
            if (this.isExpired(time, handle)) {
                return false;
            }
            if (handle.removed()) {
                return false;
            }
            if (handle.isProvisionallyRemoved()) {
                if (provisionallyRemovedEntrySet != null) {
                    provisionallyRemovedEntrySet.put(handle, null);
                }
                return false;
            }
            int n = op = takeIt ? 3 : 2;
            if (!handle.canPerform(txn, op)) {
                if (handle.onlyMgr(txn)) {
                    return false;
                }
                if (matchingLogger.isLoggable(Level.FINER)) {
                    matchingLogger.log(Level.FINER, "match, but can''t perform {0}; handle.knownMgr(txn) == {1}", new Object[]{op, new Boolean(handle.knownMgr(txn))});
                }
                if (conflictSet != null) {
                    handle.addTxns(conflictSet);
                }
                if (lockedEntrySet != null) {
                    lockedEntrySet.add(rep.id());
                }
                return false;
            }
            if (this.grab(handle, txn, op, takeIt, false)) {
                return true;
            }
            throw new AssertionError((Object)"entry became non-available while locked");
        }
    }

    private boolean grab(EntryHandle handle, TransactableMgr txn, int op, boolean takeIt, boolean recovery) {
        assert (op == (takeIt ? 3 : 2));
        assert (!recovery || takeIt);
        if (handle.knownMgr(txn)) {
            if (takeIt) {
                if (handle.managed()) {
                    if (!handle.promoteToTakeIfNeeded()) {
                        assert (txn != null);
                        if (!this.remove(handle, recovery)) {
                            return false;
                        }
                    }
                } else {
                    assert (txn == null);
                    if (handle.removed() || handle.isProvisionallyRemoved()) {
                        return false;
                    }
                    handle.provisionallyRemove();
                }
            }
        } else if (txn != null) {
            handle.add(txn, op, this);
            txn.add(handle);
        }
        return true;
    }

    void recoverTake(EntryHandle handle, Txn txn) {
        if (!this.grab(handle, txn, 3, true, true)) {
            throw new AssertionError((Object)"match not found while recovering take");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExpired(long now, EntryHandle handle) {
        EntryHandle entryHandle = handle;
        synchronized (entryHandle) {
            EntryRep rep;
            EntryRep entryRep = rep = handle.rep();
            synchronized (entryRep) {
                if (rep.getExpiration() > now) {
                    return false;
                }
                rep.setExpiration(Long.MIN_VALUE);
            }
            if (matchingLogger.isLoggable(Level.FINER)) {
                matchingLogger.log(Level.FINER, "expired {0} at {1} (now {2})", new Object[]{rep.id(), rep.getExpiration(), now});
            }
            if (!handle.isProvisionallyRemoved() && this.remove(handle, false)) {
                this.space.scheduleCancelOp(rep.id());
            }
            return true;
        }
    }

    private EntryHandle getContentsHead() {
        Iterator<EntryHandle> i$ = this.contents.iterator();
        if (i$.hasNext()) {
            EntryHandle head = i$.next();
            return head;
        }
        return null;
    }

    void add(EntryHandle handle, TransactableMgr txn) {
        EntryRep rep = handle.rep();
        EntryHandle head = this.getContentsHead();
        if (head != null && head != handle) {
            rep.shareWith(head.rep());
        }
        if (txn != null) {
            txn.add(handle);
        }
        this.contents.add(handle);
        this.idMap.put(rep.getCookie(), handle);
    }

    String[] supertypes() {
        EntryHandle head = this.getContentsHead();
        if (head == null) {
            return null;
        }
        return head.rep().superclasses();
    }

    RepEnum contents(TransactableMgr mgr) {
        return new SimpleRepEnum(mgr);
    }

    ContinuingQuery continuingQuery(EntryRep[] tmpls, TransactableMgr txn, boolean takeThem, long now) {
        return new ContinuingQuery(tmpls, txn, takeThem, now);
    }

    boolean remove(EntryHandle h, boolean recovery) {
        assert (recovery || Thread.holdsLock(h));
        boolean ok = this.contents.remove(h);
        h.removalComplete();
        if (ok) {
            this.idMap.remove(h.rep().getCookie());
            if (!recovery) {
                this.space.recordTransition(new EntryTransition(h, null, false, false, false));
            }
        }
        return ok;
    }

    private EntryHandle handleFor(EntryRep rep) {
        return (EntryHandle)this.idMap.get(rep.getCookie());
    }

    void reap() {
        long now = System.currentTimeMillis();
        for (EntryHandle handle : this.contents) {
            if (handle.removed()) continue;
            this.isExpired(now, handle);
        }
        this.contents.reap();
    }

    class ContinuingQuery {
        private final EntryRep[] tmpls;
        private final TransactableMgr txn;
        private final boolean takeThem;
        private EntryHandleTmplDesc[] descs;
        long now;
        private Iterator<EntryHandle> contentsIterator;

        private ContinuingQuery(EntryRep[] tmpls, TransactableMgr txn, boolean takeThem, long now) {
            this.tmpls = tmpls;
            this.txn = txn;
            this.takeThem = takeThem;
            this.now = now;
            this.contentsIterator = EntryHolder.this.contents.iterator();
        }

        void restart(long now) {
            if (!this.contentsIterator.hasNext()) {
                return;
            }
            this.now = now;
        }

        EntryHandle next(Set conflictSet, Set lockedEntrySet, WeakHashMap provisionallyRemovedEntrySet) throws CannotJoinException {
            matchingLogger.entering("ContinuingQuery", "next");
            while (this.contentsIterator.hasNext()) {
                boolean available;
                EntryHandle handle = this.contentsIterator.next();
                if (this.descs == null) {
                    this.descs = new EntryHandleTmplDesc[this.tmpls.length];
                    for (int i = 0; i < this.tmpls.length; ++i) {
                        this.descs[i] = EntryHandle.descFor(this.tmpls[i], handle.rep().numFields());
                    }
                }
                if (!this.handleMatch(handle) || !(available = EntryHolder.this.confirmAvailabilityWithTxn(handle.rep(), handle, this.txn, this.takeThem, this.now, conflictSet, lockedEntrySet, provisionallyRemovedEntrySet))) continue;
                return handle;
            }
            return null;
        }

        private boolean handleMatch(EntryHandle handle) {
            if (handle.removed()) {
                return false;
            }
            for (int i = 0; i < this.tmpls.length; ++i) {
                EntryRep tmpl = this.tmpls[i];
                EntryHandleTmplDesc desc = this.descs[i];
                if ((handle.hash() & desc.mask) != desc.hash || !tmpl.matches(handle.rep())) continue;
                return true;
            }
            return false;
        }
    }

    private class SimpleRepEnum
    implements RepEnum {
        private Iterator<EntryHandle> contentsIterator;
        private TransactableMgr mgr;
        private long startTime;

        SimpleRepEnum(TransactableMgr mgr) {
            this.mgr = mgr;
            this.startTime = System.currentTimeMillis();
            this.contentsIterator = EntryHolder.this.contents.iterator();
        }

        @Override
        public EntryRep nextRep() {
            iteratorLogger.entering("SimpleRepEnum", "nextRep");
            while (this.contentsIterator.hasNext()) {
                EntryHandle handle = this.contentsIterator.next();
                iteratorLogger.log(Level.FINEST, "advanced current handle to {0}", handle);
                if (!handle.canPerform(this.mgr, 2) || EntryHolder.this.isExpired(this.startTime, handle) || handle.removed()) continue;
                return handle.rep();
            }
            return null;
        }
    }
}

