/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.landlord.Landlord;
import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.MatchSetData;
import com.sun.jini.outrigger.OutriggerServer;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.start.LifeCycle;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.util.Map;
import javax.security.auth.login.LoginException;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.export.ProxyAccessor;
import net.jini.id.Uuid;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;
import net.jini.space.InternalSpaceException;
import net.jini.space.JavaSpace;

class OutriggerServerWrapper
implements OutriggerServer,
ServerProxyTrust,
ProxyAccessor {
    private final OutriggerServerImpl delegate;
    private boolean allowCalls;
    private Throwable failCallsWith;

    OutriggerServerWrapper(String[] configArgs, LifeCycle lifeCycle, boolean persistent) throws IOException, ConfigurationException, LoginException {
        try {
            this.delegate = new OutriggerServerImpl(null, lifeCycle, configArgs, persistent, this);
        }
        catch (ActivationException e) {
            throw new AssertionError((Object)e);
        }
    }

    OutriggerServerWrapper(ActivationID activationID, String[] configArgs) throws IOException, ConfigurationException, LoginException, ActivationException {
        if (activationID == null) {
            throw new NullPointerException("activationID must be non-null");
        }
        this.delegate = new OutriggerServerImpl(activationID, null, configArgs, true, this);
    }

    synchronized void holdCalls() {
        this.failCallsWith = null;
        this.allowCalls = false;
        this.notifyAll();
    }

    synchronized void rejectCalls(Throwable t) {
        if (t == null) {
            throw new NullPointerException("Throwable must not be null");
        }
        if (!(t instanceof Error || t instanceof RuntimeException || t instanceof RemoteException)) {
            throw new IllegalArgumentException("t must be an exception that can be thrown from any of OutriggerServer's methods");
        }
        this.failCallsWith = t;
        this.allowCalls = true;
        this.notifyAll();
    }

    synchronized void allowCalls() {
        this.failCallsWith = null;
        this.allowCalls = true;
        this.notifyAll();
    }

    private synchronized void gate() throws RemoteException {
        while (!this.allowCalls || this.failCallsWith != null) {
            if (this.failCallsWith != null) {
                if (this.failCallsWith instanceof RemoteException) {
                    throw (RemoteException)this.failCallsWith;
                }
                if (this.failCallsWith instanceof Error) {
                    throw (Error)this.failCallsWith;
                }
                if (this.failCallsWith instanceof RuntimeException) {
                    throw (RuntimeException)this.failCallsWith;
                }
                throw new AssertionError((Object)("Wrapper trying to throw " + this.failCallsWith));
            }
            if (this.allowCalls) continue;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new InternalSpaceException("gate method interrupted");
            }
        }
    }

    @Override
    public long[] write(EntryRep entry, Transaction txn, long lease) throws TransactionException, RemoteException {
        this.gate();
        return this.delegate.write(entry, txn, lease);
    }

    @Override
    public Object read(EntryRep tmpl, Transaction txn, long timeout, OutriggerServer.QueryCookie cookie) throws TransactionException, RemoteException, InterruptedException {
        this.gate();
        return this.delegate.read(tmpl, txn, timeout, cookie);
    }

    @Override
    public Object readIfExists(EntryRep tmpl, Transaction txn, long timeout, OutriggerServer.QueryCookie cookie) throws TransactionException, RemoteException, InterruptedException {
        this.gate();
        return this.delegate.readIfExists(tmpl, txn, timeout, cookie);
    }

    @Override
    public Object take(EntryRep tmpl, Transaction txn, long timeout, OutriggerServer.QueryCookie cookie) throws TransactionException, RemoteException, InterruptedException {
        this.gate();
        return this.delegate.take(tmpl, txn, timeout, cookie);
    }

    @Override
    public Object takeIfExists(EntryRep tmpl, Transaction txn, long timeout, OutriggerServer.QueryCookie cookie) throws TransactionException, RemoteException, InterruptedException {
        this.gate();
        return this.delegate.takeIfExists(tmpl, txn, timeout, cookie);
    }

    @Override
    public EventRegistration notify(EntryRep tmpl, Transaction txn, RemoteEventListener listener, long lease, MarshalledObject handback) throws TransactionException, RemoteException {
        this.gate();
        return this.delegate.notify(tmpl, txn, listener, lease, handback);
    }

    @Override
    public EventRegistration registerForAvailabilityEvent(EntryRep[] tmpls, Transaction txn, boolean visibilityOnly, RemoteEventListener listener, long leaseTime, MarshalledObject handback) throws TransactionException, RemoteException {
        this.gate();
        return this.delegate.registerForAvailabilityEvent(tmpls, txn, visibilityOnly, listener, leaseTime, handback);
    }

    @Override
    public long[] write(EntryRep[] entries, Transaction txn, long[] leaseTimes) throws TransactionException, RemoteException {
        this.gate();
        return this.delegate.write(entries, txn, leaseTimes);
    }

    @Override
    public Object take(EntryRep[] tmpls, Transaction tr, long timeout, int limit, OutriggerServer.QueryCookie cookie) throws TransactionException, RemoteException {
        this.gate();
        return this.delegate.take(tmpls, tr, timeout, limit, cookie);
    }

    @Override
    public MatchSetData contents(EntryRep[] tmpls, Transaction tr, long leaseTime, long limit) throws TransactionException, RemoteException {
        this.gate();
        return this.delegate.contents(tmpls, tr, leaseTime, limit);
    }

    @Override
    public EntryRep[] nextBatch(Uuid contentsQueryUuid, Uuid entryUuid) throws RemoteException {
        this.gate();
        return this.delegate.nextBatch(contentsQueryUuid, entryUuid);
    }

    @Override
    public long renew(Uuid cookie, long extension) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        this.gate();
        return this.delegate.renew(cookie, extension);
    }

    @Override
    public void cancel(Uuid cookie) throws UnknownLeaseException, RemoteException {
        this.gate();
        this.delegate.cancel(cookie);
    }

    @Override
    public Object getAdmin() throws RemoteException {
        this.gate();
        return this.delegate.getAdmin();
    }

    @Override
    public int prepare(TransactionManager mgr, long id) throws UnknownTransactionException, RemoteException {
        this.gate();
        return this.delegate.prepare(mgr, id);
    }

    @Override
    public void commit(TransactionManager mgr, long id) throws UnknownTransactionException, RemoteException {
        this.gate();
        this.delegate.commit(mgr, id);
    }

    @Override
    public void abort(TransactionManager mgr, long id) throws UnknownTransactionException, RemoteException {
        this.gate();
        this.delegate.abort(mgr, id);
    }

    @Override
    public int prepareAndCommit(TransactionManager mgr, long id) throws UnknownTransactionException, RemoteException {
        this.gate();
        return this.delegate.prepareAndCommit(mgr, id);
    }

    @Override
    public Landlord.RenewResults renewAll(Uuid[] cookies, long[] durations) throws RemoteException {
        this.gate();
        return this.delegate.renewAll(cookies, durations);
    }

    @Override
    public Map cancelAll(Uuid[] cookies) throws RemoteException {
        this.gate();
        return this.delegate.cancelAll(cookies);
    }

    @Override
    public Object getServiceProxy() throws RemoteException {
        this.gate();
        return this.delegate.getServiceProxy();
    }

    @Override
    public JavaSpace space() throws RemoteException {
        this.gate();
        return this.delegate.space();
    }

    @Override
    public Uuid contents(EntryRep tmpl, Transaction txn) throws TransactionException, RemoteException {
        this.gate();
        return this.delegate.contents(tmpl, txn);
    }

    @Override
    public EntryRep[] nextReps(Uuid iterationUuid, int max, Uuid entryUuid) throws RemoteException {
        this.gate();
        return this.delegate.nextReps(iterationUuid, max, entryUuid);
    }

    @Override
    public void delete(Uuid iterationUuid, Uuid entryUuid) throws RemoteException {
        this.gate();
        this.delegate.delete(iterationUuid, entryUuid);
    }

    @Override
    public void close(Uuid iterationUuid) throws RemoteException {
        this.gate();
        this.delegate.close(iterationUuid);
    }

    @Override
    public void destroy() throws RemoteException {
        this.gate();
        this.delegate.destroy();
    }

    @Override
    public Entry[] getLookupAttributes() throws RemoteException {
        this.gate();
        return this.delegate.getLookupAttributes();
    }

    @Override
    public void addLookupAttributes(Entry[] attrSets) throws RemoteException {
        this.gate();
        this.delegate.addLookupAttributes(attrSets);
    }

    @Override
    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) throws RemoteException {
        this.gate();
        this.delegate.modifyLookupAttributes(attrSetTemplates, attrSets);
    }

    @Override
    public String[] getLookupGroups() throws RemoteException {
        this.gate();
        return this.delegate.getLookupGroups();
    }

    @Override
    public void addLookupGroups(String[] groups) throws RemoteException {
        this.gate();
        this.delegate.addLookupGroups(groups);
    }

    @Override
    public void removeLookupGroups(String[] groups) throws RemoteException {
        this.gate();
        this.delegate.removeLookupGroups(groups);
    }

    @Override
    public void setLookupGroups(String[] groups) throws RemoteException {
        this.gate();
        this.delegate.setLookupGroups(groups);
    }

    @Override
    public LookupLocator[] getLookupLocators() throws RemoteException {
        this.gate();
        return this.delegate.getLookupLocators();
    }

    @Override
    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.gate();
        this.delegate.addLookupLocators(locators);
    }

    @Override
    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.gate();
        this.delegate.removeLookupLocators(locators);
    }

    @Override
    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.gate();
        this.delegate.setLookupLocators(locators);
    }

    @Override
    public Object getProxy() {
        return this.delegate.getProxy();
    }

    @Override
    public TrustVerifier getProxyVerifier() throws RemoteException {
        this.gate();
        return this.delegate.getProxyVerifier();
    }
}

