/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryHandle;
import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.IfExistsWatcher;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.SingletonQueryWatcher;
import com.sun.jini.outrigger.Transactable;
import com.sun.jini.outrigger.TransactableMgr;
import com.sun.jini.outrigger.Txn;
import java.util.Set;
import java.util.WeakHashMap;
import net.jini.core.transaction.TransactionException;
import net.jini.space.InternalSpaceException;

class TransactableReadIfExistsWatcher
extends SingletonQueryWatcher
implements IfExistsWatcher,
Transactable {
    private final Set lockedEntries;
    private boolean backlogFinished = false;
    private final Txn txn;
    private final WeakHashMap provisionallyRemovedEntrySet;

    TransactableReadIfExistsWatcher(long expiration, long timestamp, long startOrdinal, Set lockedEntries, WeakHashMap provisionallyRemovedEntrySet, Txn txn) {
        super(expiration, timestamp, startOrdinal);
        if (lockedEntries == null) {
            throw new NullPointerException("lockedEntries must be non-null");
        }
        if (txn == null) {
            throw new NullPointerException("txn must be non-null");
        }
        this.lockedEntries = lockedEntries;
        this.txn = txn;
        this.provisionallyRemovedEntrySet = provisionallyRemovedEntrySet;
    }

    @Override
    boolean isInterested(EntryTransition transition, long ordinal) {
        if (!transition.isVisible() && transition.isAvailable()) {
            return false;
        }
        return ordinal > this.startOrdinal && !this.isResolved();
    }

    @Override
    synchronized void process(EntryTransition transition, long now) {
        if (this.isResolved()) {
            return;
        }
        EntryHandle handle = transition.getHandle();
        EntryRep rep = handle.rep();
        boolean isVisible = transition.isVisible();
        TransactableMgr transitionTxn = transition.getTxn();
        if (isVisible && (null == transitionTxn || this.txn == transitionTxn)) {
            if (this.getServer().attemptCapture(handle, this.txn, false, null, this.provisionallyRemovedEntrySet, now, this)) {
                this.resolve(handle, null);
            } else {
                this.lockedEntries.add(rep.id());
            }
        } else if (isVisible) {
            this.lockedEntries.add(rep.id());
        } else {
            this.lockedEntries.remove(rep.id());
            if (this.backlogFinished && this.lockedEntries.isEmpty()) {
                this.resolve(null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized boolean catchUp(EntryTransition transition, long now) {
        if (this.isResolved()) {
            return true;
        }
        EntryHandle handle = transition.getHandle();
        EntryRep rep = handle.rep();
        boolean isVisible = transition.isVisible();
        TransactableMgr transitionTxn = transition.getTxn();
        if (!isVisible && transition.isAvailable()) {
            return false;
        }
        if (isVisible && (null == transitionTxn || this.txn == transitionTxn)) {
            if (this.getServer().attemptCapture(handle, this.txn, false, this.lockedEntries, this.provisionallyRemovedEntrySet, now, this)) {
                this.resolve(handle, null);
                return true;
            }
            return false;
        }
        if (isVisible) {
            EntryHandle entryHandle = handle;
            synchronized (entryHandle) {
                if (!handle.removed()) {
                    this.lockedEntries.add(rep.id());
                }
            }
            return false;
        }
        this.lockedEntries.remove(rep.id());
        return false;
    }

    @Override
    public synchronized void caughtUp() {
        this.backlogFinished = true;
        if (this.isResolved()) {
            return;
        }
        if (this.lockedEntries.isEmpty()) {
            this.resolve(null, null);
        }
    }

    @Override
    public synchronized boolean isLockedEntrySetEmpty() {
        if (!this.isResolved()) {
            throw new IllegalStateException("Query not yet resolved");
        }
        return this.lockedEntries.isEmpty();
    }

    @Override
    public synchronized int prepare(TransactableMgr mgr, OutriggerServerImpl space) {
        if (!this.isResolved()) {
            this.resolve(null, new TransactionException("completed while operation in progress"));
        }
        return 4;
    }

    @Override
    public void commit(TransactableMgr mgr, OutriggerServerImpl space) {
        throw new InternalSpaceException("committing a blocking query");
    }

    @Override
    public void abort(TransactableMgr mgr, OutriggerServerImpl space) {
        this.prepare(mgr, space);
    }
}

