/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.config.Config;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.QueryWatcher;
import com.sun.jini.outrigger.Txn;
import com.sun.jini.outrigger.TxnMonitorTask;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;

class TxnMonitor
implements Runnable {
    private LinkedList pending = new LinkedList();
    private final WakeupManager wakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
    private TaskManager taskManager;
    private OutriggerServerImpl space;
    private Thread ourThread;
    private boolean die = false;
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.transactions");

    TxnMonitor(OutriggerServerImpl space, Configuration config) throws ConfigurationException {
        if (space == null) {
            throw new NullPointerException("space must be non-null");
        }
        this.space = space;
        this.taskManager = (TaskManager)Config.getNonNullEntry(config, "com.sun.jini.outrigger", "txnMonitorTaskManager", TaskManager.class, new TaskManager());
        this.ourThread = new Thread((Runnable)this, "TxnMonitor");
        this.ourThread.setDaemon(true);
        this.ourThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.taskManager.terminate();
        this.wakeupMgr.stop();
        TxnMonitor txnMonitor = this;
        synchronized (txnMonitor) {
            this.die = true;
            this.notifyAll();
        }
        try {
            this.ourThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    OutriggerServerImpl space() {
        return this.space;
    }

    synchronized void add(QueryWatcher query, Collection transactions) {
        if (logger.isLoggable(Level.FINEST)) {
            StringBuffer buf = new StringBuffer();
            buf.append("Setting up monitor for ");
            buf.append(query);
            buf.append(" toMonitor:");
            boolean notFirst = false;
            Iterator i = transactions.iterator();
            while (i.hasNext()) {
                if (notFirst) {
                    buf.append(",");
                    notFirst = true;
                }
                buf.append(i.next());
            }
            logger.log(Level.FINEST, buf.toString());
        }
        this.pending.add(new ToMonitor(query, transactions));
        this.notifyAll();
    }

    void add(Collection transactions) {
        this.add(null, transactions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            block5: while (true) {
                ToMonitor tm;
                TxnMonitor txnMonitor = this;
                synchronized (txnMonitor) {
                    while (this.pending.isEmpty() && !this.die) {
                        this.wait();
                    }
                    if (this.die) {
                        return;
                    }
                    tm = (ToMonitor)this.pending.removeFirst();
                }
                logger.log(Level.FINER, "creating monitor tasks for {0}", tm.query);
                Iterator it = tm.txns.iterator();
                while (true) {
                    if (!it.hasNext()) continue block5;
                    Txn txn = (Txn)it.next();
                    TxnMonitorTask task = this.taskFor(txn);
                    task.add(tm.query);
                }
                break;
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private TxnMonitorTask taskFor(Txn txn) {
        TxnMonitorTask task = txn.monitorTask();
        if (task == null) {
            logger.log(Level.FINER, "creating TxnMonitorTask for {0}", txn);
            task = new TxnMonitorTask(txn, this, this.taskManager, this.wakeupMgr);
            txn.monitorTask(task);
            this.taskManager.add(task);
        }
        return task;
    }

    private static class ToMonitor {
        QueryWatcher query;
        Collection txns;

        ToMonitor(QueryWatcher query, Collection txns) {
            this.query = query;
            this.txns = txns;
        }
    }
}

