/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryHandle;
import com.sun.jini.outrigger.EntryHandleTmplDesc;
import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.FastList;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.TemplateHandle;
import com.sun.jini.outrigger.TransitionWatcher;
import com.sun.jini.outrigger.TransitionWatchers;
import java.util.Set;

class WatchersForTemplateClass {
    private final FastList<TemplateHandle> contents = new FastList();
    private final TransitionWatchers owner;

    WatchersForTemplateClass(TransitionWatchers owner) {
        if (owner == null) {
            throw new NullPointerException("owner must be non-null");
        }
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(TransitionWatcher watcher, EntryRep template) {
        TemplateHandle handle;
        for (TemplateHandle handle2 : this.contents) {
            if (!template.equals(handle2.rep())) continue;
            TemplateHandle templateHandle = handle2;
            synchronized (templateHandle) {
                if (!handle2.removed()) {
                    if (watcher.addTemplateHandle(handle2)) {
                        handle2.addTransitionWatcher(watcher);
                    }
                    return;
                }
            }
        }
        TemplateHandle templateHandle = handle = new TemplateHandle(template, this);
        synchronized (templateHandle) {
            this.contents.add(handle);
            if (watcher.addTemplateHandle(handle)) {
                handle.addTransitionWatcher(watcher);
            } else {
                this.contents.remove(handle);
            }
        }
    }

    void collectInterested(Set set, EntryTransition transition, long ordinal) {
        EntryHandle entryHandle = transition.getHandle();
        EntryRep rep = entryHandle.rep();
        long entryHash = entryHandle.hash();
        int repNumFields = rep.numFields();
        for (TemplateHandle handle : this.contents) {
            EntryHandleTmplDesc desc = handle.descFor(repNumFields);
            if ((entryHash & desc.mask) != desc.hash || !handle.matches(rep) || handle.removed()) continue;
            handle.collectInterested(set, transition, ordinal);
        }
    }

    OutriggerServerImpl getServer() {
        return this.owner.getServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reap(long now) {
        for (TemplateHandle handle : this.contents) {
            handle.reap(now);
            TemplateHandle templateHandle = handle;
            synchronized (templateHandle) {
                if (handle.isEmpty()) {
                    this.contents.remove(handle);
                }
            }
        }
        this.contents.reap();
    }
}

