/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger.snaplogstore;

import com.sun.jini.outrigger.snaplogstore.BackEnd;
import com.sun.jini.outrigger.snaplogstore.BaseObject;
import com.sun.jini.outrigger.snaplogstore.LogFile;
import com.sun.jini.outrigger.snaplogstore.Registration;
import com.sun.jini.outrigger.snaplogstore.Resource;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.space.InternalSpaceException;

class LogInputFile
extends LogFile {
    private File file;
    private static final long intBytes = 4L;
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.store");

    static Iterator logs(String basePath, boolean returnAll) throws IOException {
        LogFile lf = new LogFile(basePath);
        ArrayList inDir = new ArrayList();
        lf.existingLogs(inDir);
        if (!returnAll && inDir.size() > 0) {
            inDir.remove(inDir.size() - 1);
        }
        return new LogInputFileIterator(inDir, lf);
    }

    private LogInputFile(LogFile desc, File path) throws IOException {
        super(desc.baseDir, desc.baseFile);
        this.file = path;
    }

    synchronized void consume(BackEnd opOn) {
        try {
            DataInputStream din = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file)));
            ObjectInputStream in = new ObjectInputStream(din);
            long length = this.file.length();
            int fileVer = din.readInt();
            if (fileVer != 3) {
                this.failure("unsupported log version: " + fileVer);
            }
            long logBytes = 4L;
            int updateLen = din.readInt();
            while (updateLen != 0) {
                if (updateLen < 0) {
                    this.failure("file corrupted, negative record length at " + logBytes);
                }
                if (length - logBytes - 4L < (long)updateLen) {
                    this.failure("file corrupted, partial record at " + logBytes);
                }
                byte op = in.readByte();
                switch (op) {
                    case 1: {
                        long time = in.readLong();
                        long sessionId = in.readLong();
                        opOn.bootOp(time, sessionId);
                        break;
                    }
                    case 11: {
                        BaseObject state = (BaseObject)in.readObject();
                        opOn.joinStateOp(state);
                        break;
                    }
                    case 2: {
                        Resource rep = (Resource)in.readObject();
                        Long txnId = (Long)in.readObject();
                        opOn.writeOp(rep, txnId);
                        break;
                    }
                    case 13: {
                        Resource rep;
                        Long txnId = (Long)in.readObject();
                        int count = in.readInt();
                        for (int i = 0; i < count; ++i) {
                            rep = (Resource)in.readObject();
                            opOn.writeOp(rep, txnId);
                        }
                        break;
                    }
                    case 3: {
                        byte[] cookie = new byte[16];
                        in.readFully(cookie);
                        Long txnId = (Long)in.readObject();
                        opOn.takeOp(cookie, txnId);
                        break;
                    }
                    case 14: {
                        byte[] cookie;
                        Long txnId = (Long)in.readObject();
                        int count = in.readInt();
                        for (int i = 0; i < count; ++i) {
                            cookie = new byte[16];
                            in.readFully(cookie);
                            opOn.takeOp(cookie, txnId);
                        }
                        break;
                    }
                    case 4: {
                        Registration registration = (Registration)in.readObject();
                        opOn.registerOp(registration);
                        break;
                    }
                    case 5: {
                        byte[] cookie = new byte[16];
                        in.readFully(cookie);
                        long expires = in.readLong();
                        opOn.renewOp(cookie, expires);
                        break;
                    }
                    case 7: {
                        byte[] cookie = new byte[16];
                        in.readFully(cookie);
                        opOn.cancelOp(cookie);
                        break;
                    }
                    case 8: {
                        Long txnId = (Long)in.readObject();
                        BaseObject transaction = (BaseObject)in.readObject();
                        opOn.prepareOp(txnId, transaction);
                        break;
                    }
                    case 9: {
                        Long txnId = (Long)in.readObject();
                        opOn.commitOp(txnId);
                        break;
                    }
                    case 10: {
                        Long txnId = (Long)in.readObject();
                        opOn.abortOp(txnId);
                        break;
                    }
                    case 12: {
                        byte[] uuid = new byte[16];
                        in.readFully(uuid);
                        opOn.uuidOp(uuid);
                        break;
                    }
                    default: {
                        this.failure("log record corrupted, unknown opcode");
                    }
                }
                int offset = (int)(logBytes += 4L + (long)updateLen) & 3;
                if (offset > 0) {
                    offset = 4 - offset;
                    logBytes += (long)offset;
                    din.skipBytes(offset);
                }
                updateLen = din.readInt();
            }
        }
        catch (EOFException e) {
            this.failure("unexpected end-of-file", e);
        }
        catch (IOException e) {
            this.failure("I/O error while consuming logs", e);
        }
        catch (ClassNotFoundException e) {
            this.failure("unexpected class?", e);
        }
    }

    private void failure(String message) {
        this.failure(message, null);
    }

    private void failure(String message, Exception e) {
        String errorMsg = "Error consuming log file: " + this.file + ", " + message + "Log file consumption stopped";
        InternalSpaceException ise = new InternalSpaceException(errorMsg, e);
        logger.log(Level.SEVERE, errorMsg, ise);
        throw ise;
    }

    void finished() {
        this.file.delete();
    }

    public String toString() {
        return this.file.toString();
    }

    private static class LogInputFileIterator
    implements Iterator {
        private LogFile baseLogFile;
        private Iterator fileList;

        LogInputFileIterator(Collection files, LogFile baseLogFile) {
            this.baseLogFile = baseLogFile;
            this.fileList = files.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.fileList.hasNext();
        }

        public Object next() {
            File file = (File)this.fileList.next();
            try {
                return new LogInputFile(this.baseLogFile, file);
            }
            catch (IOException e) {
                file.delete();
                return null;
            }
        }

        @Override
        public void remove() {
            this.fileList.remove();
        }
    }
}

