/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import au.net.zeus.collection.RC;
import au.net.zeus.collection.Ref;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jini.security.policy.DynamicPolicy;

public class LoaderSplitPolicyProvider
extends Policy
implements DynamicPolicy {
    private static final ProtectionDomain myDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

        @Override
        public ProtectionDomain run() {
            return LoaderSplitPolicyProvider.class.getProtectionDomain();
        }
    });
    private final ClassLoader loader;
    private final Policy loaderPolicy;
    private final Policy defaultPolicy;
    private final ConcurrentMap<ClassLoader, Policy> delegateMap;

    public LoaderSplitPolicyProvider(ClassLoader loader, Policy loaderPolicy, Policy defaultPolicy) {
        if (loader == null || loaderPolicy == null || defaultPolicy == null) {
            throw new NullPointerException();
        }
        this.loader = loader;
        this.loaderPolicy = loaderPolicy;
        this.defaultPolicy = defaultPolicy;
        this.delegateMap = RC.concurrentMap(new ConcurrentHashMap(), Ref.WEAK_IDENTITY, Ref.STRONG, 1000L, 0L);
        this.ensureDependenciesResolved();
    }

    @Override
    public PermissionCollection getPermissions(CodeSource source) {
        return this.defaultPolicy.getPermissions(source);
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (domain == myDomain) {
            Permissions pc = new Permissions();
            ((PermissionCollection)pc).add(new AllPermission());
            return pc;
        }
        return this.getDelegate(domain.getClassLoader()).getPermissions(domain);
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        return domain == myDomain || this.getDelegate(domain.getClassLoader()).implies(domain, permission);
    }

    @Override
    public void refresh() {
        this.loaderPolicy.refresh();
        this.defaultPolicy.refresh();
    }

    @Override
    public boolean grantSupported() {
        return this.loaderPolicy instanceof DynamicPolicy && ((DynamicPolicy)((Object)this.loaderPolicy)).grantSupported() && this.defaultPolicy instanceof DynamicPolicy && ((DynamicPolicy)((Object)this.defaultPolicy)).grantSupported();
    }

    @Override
    public void grant(Class cl, Principal[] principals, Permission[] permissions) {
        if (!this.grantSupported()) {
            throw new UnsupportedOperationException("grants not supported");
        }
        ((DynamicPolicy)((Object)this.getDelegate(LoaderSplitPolicyProvider.getClassLoader(cl)))).grant(cl, principals, permissions);
    }

    @Override
    public Permission[] getGrants(Class cl, Principal[] principals) {
        if (!this.grantSupported()) {
            throw new UnsupportedOperationException("grants not supported");
        }
        return ((DynamicPolicy)((Object)this.getDelegate(LoaderSplitPolicyProvider.getClassLoader(cl)))).getGrants(cl, principals);
    }

    private void ensureDependenciesResolved() {
        this.getDelegate(this.loader);
    }

    private Policy getDelegate(final ClassLoader ldr) {
        if (ldr == null) {
            return this.loaderPolicy;
        }
        Policy p = (Policy)this.delegateMap.get(ldr);
        if (p == null) {
            p = AccessController.doPrivileged(new PrivilegedAction<Policy>(){

                @Override
                public Policy run() {
                    for (ClassLoader l = ldr; l != null; l = l.getParent()) {
                        if (l != LoaderSplitPolicyProvider.this.loader) continue;
                        return LoaderSplitPolicyProvider.this.loaderPolicy;
                    }
                    return LoaderSplitPolicyProvider.this.defaultPolicy;
                }
            });
            this.delegateMap.putIfAbsent(ldr, p);
        }
        return p;
    }

    private static ClassLoader getClassLoader(final Class cl) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return cl.getClassLoader();
            }
        });
    }
}

