/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import java.io.File;
import java.io.FilePermission;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.river.impl.net.UriString;

public final class SharedActivationPolicyPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private final Permission policyPermission;

    public SharedActivationPolicyPermission(String policy) {
        super(policy);
        this.policyPermission = this.init(policy);
    }

    public SharedActivationPolicyPermission(String policy, String action) {
        super(policy);
        this.policyPermission = this.init(policy);
    }

    private Permission init(String policy) {
        String uncanonicalPath;
        block7: {
            if (policy == null) {
                throw new NullPointerException("Null policy string not allowed");
            }
            uncanonicalPath = null;
            try {
                URL url = new URL(policy);
                uncanonicalPath = url.toExternalForm();
                if (policy.startsWith("file:") || policy.startsWith("FILE:")) {
                    String path = null;
                    try {
                        uncanonicalPath = UriString.fixWindowsURI(uncanonicalPath);
                        uncanonicalPath = UriString.escapeIllegalCharacters(uncanonicalPath);
                        path = new File(new URI(uncanonicalPath)).getPath();
                    }
                    catch (URISyntaxException ex) {
                        path = uncanonicalPath.replace('/', File.separatorChar);
                    }
                    catch (IllegalArgumentException ex) {
                        path = uncanonicalPath.replace('/', File.separatorChar);
                    }
                    uncanonicalPath = path;
                    break block7;
                }
                uncanonicalPath = uncanonicalPath.replace('/', File.separatorChar);
            }
            catch (MalformedURLException me) {
                uncanonicalPath = policy;
            }
        }
        return new FilePermission(uncanonicalPath, "read");
    }

    @Override
    public boolean implies(Permission p) {
        if (p == null) {
            return false;
        }
        if (!(p instanceof SharedActivationPolicyPermission)) {
            return false;
        }
        SharedActivationPolicyPermission other = (SharedActivationPolicyPermission)p;
        boolean answer = this.policyPermission.implies(other.policyPermission);
        return answer;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SharedActivationPolicyPermission)) {
            return false;
        }
        SharedActivationPolicyPermission other = (SharedActivationPolicyPermission)obj;
        boolean answer = this.policyPermission.equals(other.policyPermission);
        return answer;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getActions() {
        return "";
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new Collection();
    }

    private static class Collection
    extends PermissionCollection {
        private static final long serialVersionUID = 1L;
        private final ArrayList perms = new ArrayList(3);

        private Collection() {
        }

        @Override
        public synchronized void add(Permission p) {
            if (this.isReadOnly()) {
                throw new SecurityException("Collection cannot be modified.");
            }
            if (this.perms.indexOf(p) < 0) {
                this.perms.add(p);
            }
        }

        @Override
        public synchronized boolean implies(Permission p) {
            int i = this.perms.size();
            while (--i >= 0) {
                if (!((Permission)this.perms.get(i)).implies(p)) continue;
                return true;
            }
            return false;
        }

        public Enumeration elements() {
            return Collections.enumeration(this.perms);
        }
    }
}

