/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamPlugThread
extends Thread {
    private InputStream in;
    private OutputStream out;

    public StreamPlugThread(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public void run() {
        byte[] buf = new byte[2048];
        try {
            int count;
            while ((count = this.in.read(buf)) != -1) {
                this.out.write(buf, 0, count);
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void plugTogether(InputStream in, OutputStream out) {
        new StreamPlugThread(in, out).start();
    }

    public static void plugTogether(OutputStream out, InputStream in) {
        new StreamPlugThread(in, out).start();
    }

    public static Process userProg(String cmd) throws IOException {
        Process proc = Runtime.getRuntime().exec(cmd);
        StreamPlugThread.plugTogether(System.in, proc.getOutputStream());
        StreamPlugThread.plugTogether(System.out, proc.getInputStream());
        StreamPlugThread.plugTogether(System.err, proc.getErrorStream());
        return proc;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            StreamPlugThread.error("usage: StreamPlugThread \"command\"");
        }
        try {
            StreamPlugThread.userProg(args[0]);
        }
        catch (IOException e) {
            StreamPlugThread.error("I/O Exception: " + e);
        }
    }

    public static void error(String err) {
        System.err.println("StreamPlugThread: " + err);
        System.exit(1);
    }
}

