/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskManager {
    protected static final Logger logger = Logger.getLogger("com.sun.jini.thread.TaskManager");
    protected final ArrayList tasks = new ArrayList();
    protected int firstPending = 0;
    protected final List roTasks = Collections.unmodifiableList(this.tasks);
    protected final List threads = new ArrayList();
    protected final int maxThreads;
    protected final long timeout;
    protected final float loadFactor;
    protected boolean terminated = false;

    public TaskManager() {
        this(10, 15000L, 3.0f);
    }

    public TaskManager(int maxThreads, long timeout, float loadFactor) {
        this.maxThreads = maxThreads;
        this.timeout = timeout;
        this.loadFactor = loadFactor;
    }

    public synchronized void addIfNew(Task t) {
        if (!this.tasks.contains(t)) {
            this.add(t);
        }
    }

    public synchronized void add(Task t) {
        this.tasks.add(t);
        boolean poke = true;
        while (this.threads.size() < this.maxThreads && this.needThread()) {
            TaskThread th;
            try {
                th = new TaskThread();
                th.start();
            }
            catch (Throwable tt) {
                try {
                    logger.log(this.threads.isEmpty() ? Level.SEVERE : Level.WARNING, "thread creation exception", tt);
                }
                catch (Throwable ttt) {}
                break;
            }
            this.threads.add(th);
            poke = false;
        }
        if (poke && this.threads.size() > this.firstPending && !this.runAfter(t, this.tasks.size() - 1)) {
            this.notify();
        }
    }

    public synchronized void addAll(Collection c) {
        Iterator iter2 = c.iterator();
        while (iter2.hasNext()) {
            this.add((Task)iter2.next());
        }
    }

    protected boolean needThread() {
        int bound = (int)(this.loadFactor * (float)this.threads.size());
        int max = this.tasks.size();
        if (max < bound) {
            return false;
        }
        if (this.runAfter((Task)this.tasks.get(--max), max)) {
            return false;
        }
        int ready = this.firstPending + 1;
        if (ready > bound) {
            return true;
        }
        for (int i = this.firstPending; i < max; ++i) {
            if (this.runAfter((Task)this.tasks.get(i), i) || ++ready <= bound) continue;
            return true;
        }
        return false;
    }

    private boolean runAfter(Task t, int i) {
        try {
            return t.runAfter(this.roTasks, i);
        }
        catch (Throwable tt) {
            try {
                logger.log(Level.WARNING, "Task.runAfter exception", tt);
            }
            catch (Throwable ttt) {
                // empty catch block
            }
            return false;
        }
    }

    public synchronized boolean removeIfPending(Task t) {
        return this.removeTask(t, this.firstPending);
    }

    public synchronized boolean remove(Task t) {
        return this.removeTask(t, 0);
    }

    private boolean removeTask(Task t, int min) {
        int i = this.tasks.size();
        while (--i >= min) {
            if (this.tasks.get(i) != t) continue;
            this.tasks.remove(i);
            if (i < this.firstPending) {
                --this.firstPending;
                int j = this.threads.size();
                while (--j >= 0) {
                    TaskThread thread = (TaskThread)this.threads.get(j);
                    if (thread.task != t) continue;
                    if (thread == Thread.currentThread()) break;
                    thread.interrupt();
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public synchronized void terminate() {
        this.terminated = true;
        int i = this.threads.size();
        while (--i >= 0) {
            ((Thread)this.threads.get(i)).interrupt();
        }
    }

    public synchronized ArrayList getPending() {
        ArrayList tc = (ArrayList)this.tasks.clone();
        int i = this.firstPending;
        while (--i >= 0) {
            tc.remove(0);
        }
        return tc;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    private class TaskThread
    extends Thread {
        public Task task;

        public TaskThread() {
            super("task");
            this.task = null;
            this.setDaemon(true);
        }

        private boolean takeTask() {
            int size = TaskManager.this.tasks.size();
            for (int i = TaskManager.this.firstPending; i < size; ++i) {
                Task t = (Task)TaskManager.this.tasks.get(i);
                if (TaskManager.this.runAfter(t, i)) continue;
                if (i > TaskManager.this.firstPending) {
                    TaskManager.this.tasks.remove(i);
                    TaskManager.this.tasks.add(TaskManager.this.firstPending, t);
                }
                ++TaskManager.this.firstPending;
                this.task = t;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                TaskManager taskManager = TaskManager.this;
                synchronized (taskManager) {
                    if (TaskManager.this.terminated) {
                        return;
                    }
                    if (this.task != null) {
                        int i = TaskManager.this.firstPending;
                        while (--i >= 0) {
                            if (TaskManager.this.tasks.get(i) != this.task) continue;
                            TaskManager.this.tasks.remove(i);
                            --TaskManager.this.firstPending;
                            break;
                        }
                        this.task = null;
                        TaskThread.interrupted();
                    }
                    if (!this.takeTask()) {
                        try {
                            TaskManager.this.wait(TaskManager.this.timeout);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (TaskManager.this.terminated || !this.takeTask()) {
                            TaskManager.this.threads.remove(this);
                            return;
                        }
                    }
                }
                try {
                    this.task.run();
                    continue;
                }
                catch (Throwable t) {
                    try {
                        logger.log(Level.WARNING, "Task.run exception", t);
                    }
                    catch (Throwable throwable) {
                    }
                    continue;
                }
                break;
            }
        }
    }

    public static interface Task
    extends Runnable {
        public boolean runAfter(List var1, int var2);
    }
}

