/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CheckSer {
    private static final int MASK = 24;
    private static ResourceBundle resources;
    private static boolean resinit;

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"/vob/jive/classes"};
        }
        for (int i = 0; i < args.length; ++i) {
            CheckSer.check(args[i], args[i].length() + 1);
        }
    }

    public static void check(String dir, int strip) {
        String[] files = new File(dir).list();
        if (files == null) {
            CheckSer.print("checkser.nodir", dir);
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            String file = dir + File.separatorChar + files[i];
            if (file.endsWith(".class")) {
                CheckSer.checkClass(file, strip);
                continue;
            }
            if (!new File(file).isDirectory()) continue;
            CheckSer.check(file, strip);
        }
    }

    private static void checkClass(String file, int strip) {
        file = file.substring(strip, file.length() - 6);
        file = file.replace(File.separatorChar, '.');
        try {
            Class<?> c = Class.forName(file);
            if (c.isInterface() || !Serializable.class.isAssignableFrom(c)) {
                return;
            }
            Field f = c.getDeclaredField("serialVersionUID");
            if ((f.getModifiers() & 0x18) != 24) {
                System.out.println(file);
            }
        }
        catch (ClassNotFoundException e) {
            CheckSer.print("checkser.failed", file);
        }
        catch (NoClassDefFoundError e) {
            CheckSer.print("checkser.failed", file);
        }
        catch (NoSuchFieldException e) {
            System.out.println(file);
        }
    }

    private static synchronized String getString(String key) {
        if (!resinit) {
            try {
                resources = ResourceBundle.getBundle("com.sun.jini.tool.resources.checkser");
                resinit = true;
            }
            catch (MissingResourceException e) {
                e.printStackTrace();
            }
        }
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static void print(String key, String val) {
        String fmt = CheckSer.getString(key);
        if (fmt == null) {
            fmt = "no text found: \"" + key + "\" {0}";
        }
        System.out.println(MessageFormat.format(fmt, val));
    }

    static {
        resinit = false;
    }
}

