/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;

public class IncomingMulticastAnnouncement {
    protected ServiceID serviceID;
    protected LookupLocator locator;
    protected String[] groups;
    protected final int protoVersion = 1;

    public IncomingMulticastAnnouncement(DatagramPacket p) throws IOException {
        ByteArrayInputStream bs = new ByteArrayInputStream(p.getData());
        DataInputStream ds = new DataInputStream(bs);
        int proto = ds.readInt();
        if (proto != 1) {
            throw new IOException("unsupported protocol version: " + proto);
        }
        String host = ds.readUTF();
        int port = ds.readInt();
        if (port <= 0 || port >= 65536) {
            throw new IOException("port number out of range: " + port);
        }
        this.locator = new LookupLocator(host, port);
        this.serviceID = new ServiceID(ds);
        int groupCount = ds.readInt();
        if (groupCount < 0 || groupCount > bs.available() / 2) {
            throw new IOException("group count invalid: " + groupCount);
        }
        this.groups = new String[groupCount];
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i] = ds.readUTF();
        }
    }

    public ServiceID getServiceID() {
        return this.serviceID;
    }

    public LookupLocator getLocator() {
        return this.locator;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public int hashCode() {
        return this.serviceID.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof IncomingMulticastAnnouncement && ((IncomingMulticastAnnouncement)o).serviceID.equals(this.serviceID);
    }
}

