/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.http;

import com.sun.jini.jeri.internal.http.ConnectionTimer;
import com.sun.jini.jeri.internal.http.HttpServerConnection;
import com.sun.jini.jeri.internal.http.HttpServerManager;
import com.sun.jini.jeri.internal.http.HttpSettings;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.http.Constraints;
import net.jini.jeri.http.HttpEndpoint;
import net.jini.security.Security;
import net.jini.security.SecurityContext;
import org.apache.river.config.LocalHostLookup;

public final class HttpServerEndpoint
implements ServerEndpoint {
    private static final Executor systemThreadPool = (Executor)Security.doPrivileged(new GetThreadPoolAction(false));
    private static final HttpServerManager serverManager;
    private static final ConnectionTimer connTimer;
    private static final Logger logger;
    private final String host;
    private final int port;
    private final SocketFactory sf;
    private final ServerSocketFactory ssf;

    public static HttpServerEndpoint getInstance(int port) {
        return HttpServerEndpoint.getInstance(null, port, null, null);
    }

    public static HttpServerEndpoint getInstance(String host, int port) {
        return HttpServerEndpoint.getInstance(host, port, null, null);
    }

    public static HttpServerEndpoint getInstance(String host, int port, SocketFactory sf, ServerSocketFactory ssf) {
        return new HttpServerEndpoint(host, port, sf, ssf);
    }

    private HttpServerEndpoint(String host, int port, SocketFactory sf, ServerSocketFactory ssf) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port number out of range: " + port);
        }
        this.host = host;
        this.port = port;
        this.sf = sf;
        this.ssf = ssf;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public SocketFactory getSocketFactory() {
        return this.sf;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    @Override
    public InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        return Constraints.check(constraints, true);
    }

    @Override
    public Endpoint enumerateListenEndpoints(ServerEndpoint.ListenContext listenContext) throws IOException {
        LE listenEndpoint;
        ServerEndpoint.ListenCookie listenCookie;
        if (listenContext == null) {
            throw new NullPointerException();
        }
        String localHost = this.host;
        if (localHost == null) {
            InetAddress localAddr;
            try {
                localAddr = (InetAddress)Security.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        return LocalHostLookup.getLocalHost();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                LocalHostLookup.getLocalHost();
                throw new UnknownHostException("access to resolve local host denied");
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkConnect(localAddr.getHostName(), -1);
                }
                catch (SecurityException e) {
                    throw new SecurityException("access to resolve local host denied");
                }
            }
            localHost = localAddr.getHostAddress();
        }
        if (!((listenCookie = listenContext.addListenEndpoint(listenEndpoint = new LE())) instanceof LE.Cookie)) {
            throw new IllegalArgumentException();
        }
        LE.Cookie cookie = (LE.Cookie)listenCookie;
        if (!listenEndpoint.equals(cookie.getLE())) {
            throw new IllegalArgumentException();
        }
        return HttpEndpoint.getInstance(localHost, cookie.getPort(), this.sf);
    }

    public int hashCode() {
        return this.port ^ (this.host != null ? this.host.hashCode() : 0) ^ (this.sf != null ? this.sf.hashCode() : 0) ^ (this.ssf != null ? this.ssf.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HttpServerEndpoint)) {
            return false;
        }
        HttpServerEndpoint other = (HttpServerEndpoint)obj;
        return Util.equals(this.host, other.host) && this.port == other.port && Util.sameClassAndEquals(this.sf, other.sf) && Util.sameClassAndEquals(this.ssf, other.ssf);
    }

    public String toString() {
        return "HttpServerEndpoint[" + (this.host != null ? this.host + ":" : "") + this.port + (this.ssf != null ? "," + this.ssf : "") + (this.sf != null ? "," + this.sf : "") + "]";
    }

    private static void setSocketOptions(Socket socket) {
        block5: {
            block4: {
                try {
                    socket.setTcpNoDelay(true);
                }
                catch (SocketException e) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block4;
                    LogUtil.logThrow(logger, Levels.HANDLED, HttpServerEndpoint.class, "setSocketOptions", "exception setting TCP_NODELAY on socket {0}", new Object[]{socket}, e);
                }
            }
            try {
                socket.setKeepAlive(true);
            }
            catch (SocketException e) {
                if (!logger.isLoggable(Levels.HANDLED)) break block5;
                LogUtil.logThrow(logger, Levels.HANDLED, HttpServerEndpoint.class, "setSocketOptions", "exception setting SO_KEEPALIVE on socket {0}", new Object[]{socket}, e);
            }
        }
    }

    static {
        HttpSettings hs = HttpEndpoint.getHttpSettings();
        serverManager = new HttpServerManager(hs.getResponseAckTimeout());
        connTimer = new ConnectionTimer(hs.getServerConnectionTimeout());
        logger = Logger.getLogger("net.jini.jeri.http.server");
    }

    private static class LH
    implements ServerEndpoint.ListenHandle {
        private final RequestDispatcher requestDispatcher;
        private final ServerSocket serverSocket;
        private final SecurityContext context;
        private final ServerEndpoint.ListenCookie cookie;
        private long acceptFailureTime = 0L;
        private int acceptFailureCount;
        private final Object lock = new Object();
        private boolean closed = false;
        private final Set conns = new HashSet();

        LH(RequestDispatcher requestDispatcher, ServerSocket serverSocket, SecurityContext context, ServerEndpoint.ListenCookie cookie) {
            this.requestDispatcher = requestDispatcher;
            this.serverSocket = serverSocket;
            this.context = context;
            this.cookie = cookie;
        }

        void startAccepting() {
            systemThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        LH.this.executeAcceptLoop();
                    }
                    finally {
                        try {
                            LH.this.serverSocket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }, this.toString() + " accept loop");
        }

        private void executeAcceptLoop() {
            AccessController.doPrivileged(this.context.wrap(new PrivilegedAction(){

                public Object run() {
                    LH.this.executeAcceptLoop0();
                    return null;
                }
            }), this.context.getAccessControlContext());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void executeAcceptLoop0() {
            while (true) {
                Socket socket = null;
                try {
                    socket = this.serverSocket.accept();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "accepted socket {0} from server socket {1}", new Object[]{socket, this.serverSocket});
                    }
                    HttpServerEndpoint.setSocketOptions(socket);
                    new Connection(socket);
                    continue;
                }
                catch (Throwable t) {
                    try {
                        Object object = this.lock;
                        // MONITORENTER : object
                        if (this.closed) {
                            // MONITOREXIT : object
                            return;
                        }
                        // MONITOREXIT : object
                        try {
                            if (logger.isLoggable(Level.WARNING)) {
                                LogUtil.logThrow(logger, Level.WARNING, HttpServerEndpoint.class, "executeAcceptLoop", "accept loop for {0} throws", new Object[]{this.serverSocket}, t);
                            }
                        }
                        catch (Throwable tt) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    if (!(t instanceof SecurityException)) {
                        try {
                            Object e = this.lock;
                            // MONITORENTER : e
                            Object[] snapshot = this.closed ? null : this.conns.toArray();
                            // MONITOREXIT : e
                            if (snapshot != null) {
                                for (int i = 0; i < snapshot.length; ++i) {
                                    ((Connection)snapshot[i]).shutdown(false);
                                }
                            }
                        }
                        catch (OutOfMemoryError e) {
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    boolean knownFailure = t instanceof Exception || t instanceof OutOfMemoryError || t instanceof NoClassDefFoundError;
                    if (!knownFailure) throw (Error)t;
                    if (!this.continueAfterAcceptFailure(t)) return;
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "closed server socket {0}", this.serverSocket);
            }
            Iterator i = this.conns.iterator();
            while (i.hasNext()) {
                ((Connection)i.next()).shutdown(true);
            }
        }

        @Override
        public ServerEndpoint.ListenCookie getCookie() {
            return this.cookie;
        }

        public String toString() {
            return "HttpServerEndpoint.LH[" + this.serverSocket + "]";
        }

        private boolean continueAfterAcceptFailure(Throwable t) {
            int NFAIL = 10;
            int NMSEC = 5000;
            long now = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || now - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = now;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
            }
            return true;
        }

        private class Connection
        extends HttpServerConnection {
            private final Socket socket;
            private final Object connLock;
            private boolean connClosed;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Connection(Socket socket) throws IOException {
                super(socket, LH.this.requestDispatcher, serverManager);
                this.connLock = new Object();
                this.socket = socket;
                boolean needShutdown = false;
                Object object = LH.this.lock;
                synchronized (object) {
                    if (LH.this.closed) {
                        needShutdown = true;
                    } else {
                        LH.this.conns.add(this);
                    }
                }
                if (needShutdown) {
                    this.shutdown(true);
                } else {
                    this.start();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shutdown(boolean force) {
                Object object = this.connLock;
                synchronized (object) {
                    if (this.connClosed) {
                        return true;
                    }
                    this.connClosed = super.shutdown(force);
                    if (!this.connClosed) {
                        return false;
                    }
                }
                connTimer.cancelTimeout(this);
                object = LH.this.lock;
                synchronized (object) {
                    if (!LH.this.closed) {
                        LH.this.conns.remove(this);
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "shut down connection on socket {0}", this.socket);
                }
                return true;
            }

            @Override
            protected void checkPermissions() {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkAccept(this.socket.getInetAddress().getHostAddress(), this.socket.getPort());
                }
            }

            @Override
            protected InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
                return Constraints.check(constraints, true);
            }

            @Override
            protected void populateContext(Collection context) {
                Util.populateContext(context, this.socket.getInetAddress());
            }

            @Override
            protected void idle() {
                connTimer.scheduleTimeout(this, false);
            }

            @Override
            protected void busy() {
                connTimer.cancelTimeout(this);
            }
        }
    }

    private class LE
    implements ServerEndpoint.ListenEndpoint {
        LE() {
        }

        @Override
        public void checkPermissions() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkListen(HttpServerEndpoint.this.port);
            }
        }

        @Override
        public ServerEndpoint.ListenHandle listen(RequestDispatcher requestDispatcher) throws IOException {
            if (requestDispatcher == null) {
                throw new NullPointerException();
            }
            ServerSocket serverSocket = HttpServerEndpoint.this.ssf != null ? HttpServerEndpoint.this.ssf.createServerSocket(HttpServerEndpoint.this.port) : new ServerSocket(HttpServerEndpoint.this.port);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, HttpServerEndpoint.this.ssf == null ? "created server socket {0}" : "created server socket {0} using factory {1}", new Object[]{serverSocket, HttpServerEndpoint.this.ssf});
            }
            Cookie cookie = new Cookie(serverSocket.getLocalPort());
            LH listenHandle = new LH(requestDispatcher, serverSocket, Security.getContext(), cookie);
            listenHandle.startAccepting();
            return listenHandle;
        }

        private int getPort() {
            return HttpServerEndpoint.this.port;
        }

        private ServerSocketFactory getSSF() {
            return HttpServerEndpoint.this.ssf;
        }

        public int hashCode() {
            return HttpServerEndpoint.this.port ^ (HttpServerEndpoint.this.ssf != null ? HttpServerEndpoint.this.ssf.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LE)) {
                return false;
            }
            LE other = (LE)obj;
            return HttpServerEndpoint.this.port == other.getPort() && Util.sameClassAndEquals(HttpServerEndpoint.this.ssf, other.getSSF());
        }

        public String toString() {
            return "HttpServerEndpoint.LE[" + HttpServerEndpoint.this.port + (HttpServerEndpoint.this.ssf != null ? "," + HttpServerEndpoint.this.ssf : "") + "]";
        }

        private class Cookie
        implements ServerEndpoint.ListenCookie {
            private final int port;

            Cookie(int port) {
                this.port = port;
            }

            LE getLE() {
                return LE.this;
            }

            int getPort() {
                return this.port;
            }

            public String toString() {
                return "HttpServerEndpoint.LE.Cookie[" + this.port + "]";
            }
        }
    }
}

