/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import org.databene.contiperf.Config;
import org.databene.contiperf.ExecutionConfig;
import org.databene.contiperf.PercentileRequirement;
import org.databene.contiperf.PerformanceRequirement;
import org.databene.contiperf.report.AbstractReportModule;
import org.databene.contiperf.report.GoogleLatencyRenderer;
import org.databene.contiperf.report.ReportContext;
import org.databene.contiperf.report.ReportModule;
import org.databene.contiperf.report.ReportUtil;
import org.databene.contiperf.report.Verdict;
import org.databene.stat.LatencyCounter;

public class HtmlReportModule
extends AbstractReportModule {
    private static final String REPORT_FILENAME = "index.html";
    private static final int WIDTH = 320;
    private static final int HEIGHT = 240;
    private static final String CPF_MARKER_1 = "<!-- !!__cpf-marker1__!! -->";
    private static final String CPF_MARKER_2 = "<!-- !!__cpf-marker2__!! -->";
    ReportContext context;
    private static boolean initialized = false;
    private static DecimalFormat lf = new DecimalFormat();

    public void setContext(ReportContext context) {
        this.context = context;
    }

    public void completed(String id, LatencyCounter[] counters, ExecutionConfig executionConfig, PerformanceRequirement requirement) {
        HtmlReportModule.updateReport(id, counters, executionConfig, requirement, this.context);
    }

    private static synchronized void updateReport(String id, LatencyCounter[] counters, ExecutionConfig executionConfig, PerformanceRequirement requirement, ReportContext context) {
        File reportFile = HtmlReportModule.reportFile();
        if (!initialized || !reportFile.exists()) {
            HtmlReportModule.initReportFile(reportFile, id, counters, executionConfig, requirement, context);
        } else {
            HtmlReportModule.extendReportFile(reportFile, id, counters, executionConfig, requirement, context);
        }
    }

    private static File reportFile() {
        return new File(Config.instance().getReportFolder(), REPORT_FILENAME);
    }

    private static void initReportFile(File reportFile, String id, LatencyCounter[] counters, ExecutionConfig executionConfig, PerformanceRequirement requirement, ReportContext context) {
        initialized = true;
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(reportFile));
            out.println("<html>");
            out.println("<head>");
            out.println("<title>ContiPerf Report</title>");
            out.println("</head>");
            out.println("<body style='font-family:Verdana;'>");
            out.println("<center>");
            out.println("<h1 style='color:#EE6600'>ContiPerf Report</h1>");
            boolean first = true;
            for (ReportModule module : context.getReportModules()) {
                String ref = module.getReportReference(null);
                if (ref == null) continue;
                if (!first) {
                    out.print("&nbsp;|&nbsp;");
                }
                HtmlReportModule.appendRef(ref, module.getReportReferenceLabel(null), out);
                first = false;
            }
            if (!first) {
                out.print("&nbsp;|&nbsp;");
            }
            out.println("<a href='http://databene.org/contiperf'>Help</a>");
            out.println("<hr/>");
            out.println("<br/>");
            out.println("<table border='1' cellspacing='0' cellpadding='3px' style='border-color:#eee'>");
            out.println("\t<tr>");
            out.println("\t\t<th style='background-color:#ffffdd; color:#EE6600'>&nbsp;&nbsp;&nbsp;</th>");
            out.println("\t\t<th style='background-color:#ffffdd; color:#EE6600'>Test</th>");
            out.println("\t<tr>");
            HtmlReportModule.appendHeader(id, counters[0], requirement, out);
            out.println(CPF_MARKER_1);
            out.println("</table>");
            out.println("<br/>");
            out.println("<hr/>");
            HtmlReportModule.appendEntry(id, counters, executionConfig, requirement, out, context);
            out.println(CPF_MARKER_2);
            out.println("<hr/>");
            out.println("<div style='color:#EE6600;'>Report created by Volker Bergmann's <a href='http://databene.org'>Databene</a> <a href='http://databene.org/contiperf'>ContiPerf</a></div>");
            out.println("</center>");
            out.println("</body>");
            out.println("</html>");
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void extendReportFile(File reportFile, String id, LatencyCounter[] counters, ExecutionConfig executionConfig, PerformanceRequirement requirement, ReportContext context) {
        try {
            String line;
            File tempFile = File.createTempFile("index", "html", reportFile.getParentFile());
            PrintWriter out = new PrintWriter(tempFile);
            BufferedReader in = new BufferedReader(new FileReader(reportFile));
            while (!(line = in.readLine()).contains(CPF_MARKER_1)) {
                out.println(line);
            }
            HtmlReportModule.appendHeader(id, counters[0], requirement, out);
            out.println(line);
            while (!(line = in.readLine()).contains(CPF_MARKER_2)) {
                out.println(line);
            }
            HtmlReportModule.appendEntry(id, counters, executionConfig, requirement, out, context);
            out.println(line);
            while ((line = in.readLine()) != null) {
                out.println(line);
            }
            out.close();
            in.close();
            reportFile.delete();
            tempFile.renameTo(reportFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void appendHeader(String id, LatencyCounter counter, PerformanceRequirement requirement, PrintWriter out) {
        out.println("\t<tr>");
        out.println("\t\t" + HtmlReportModule.successCell(counter, requirement));
        out.println("\t\t<td><a href='#" + id + "'>" + id + "</td>");
        out.println("\t<tr>");
    }

    private static String successCell(LatencyCounter counter, PerformanceRequirement requirement) {
        boolean success = ReportUtil.success(counter, requirement);
        return "<td style='background-color:" + (success ? "#00BB00" : "RED") + ";'>&nbsp;</td>";
    }

    private static void appendEntry(String serviceId, LatencyCounter[] counters, ExecutionConfig executionConfig, PerformanceRequirement requirement, PrintWriter out, ReportContext context) {
        out.println("<a name='" + serviceId + "'><h2 style='color:#EE6600'>" + serviceId + "</h2></a>");
        out.println("<table>");
        out.println("\t<tr>");
        out.println("\t\t<td>");
        HtmlReportModule.renderStats(serviceId, counters[0], out);
        out.println("\t\t</td>");
        out.println("\t\t<td>");
        HtmlReportModule.printStats(serviceId, counters, executionConfig, requirement, out);
        out.println("\t\t</td>");
        out.println("\t</tr>");
        out.println("</table>");
        out.println("<br/>");
        boolean first = true;
        for (ReportModule module : context.getReportModules()) {
            String ref = module.getReportReference(serviceId);
            if (ref == null) continue;
            if (!first) {
                out.print("&nbsp;|&nbsp;");
            }
            String label = module.getReportReferenceLabel(serviceId);
            HtmlReportModule.appendRef(ref, label, out);
            first = false;
        }
        out.println("<br/><br/><br/>");
    }

    private static void appendRef(String ref, String label, PrintWriter out) {
        out.print("<a href='" + ref + "'>" + label + "</a>");
    }

    private static void renderStats(String id, LatencyCounter counter, PrintWriter out) {
        String chartUrl = new GoogleLatencyRenderer().render(counter, null, 320, 240);
        out.println("\t\t\t<img src='" + chartUrl + "' width='" + 320 + "', height='" + 240 + "'/>");
    }

    private static void printStats(String id, LatencyCounter[] counters, ExecutionConfig executionConfig, PerformanceRequirement requirement, PrintWriter out) {
        out.println("\t\t\t<table style='font-family:sans-serif;'>");
        Date startDate = new Date(counters[0].getStartTime());
        out.println("\t<tr><th>Started at:</th><td colspan='2'>" + DateFormat.getDateTimeInstance().format(startDate) + "</td></tr>");
        HtmlReportModule.printStatLine("Measured invocations:", counters[0].sampleCount(), null, null, null, null, out);
        if (executionConfig.getThreads() > 1) {
            HtmlReportModule.printStatLine("Thread Count:", executionConfig.getThreads(), null, null, null, null, out);
        }
        if (executionConfig.getWarmUp() > 0) {
            HtmlReportModule.printStatLine("Warm up:", executionConfig.getWarmUp(), "ms", null, null, null, out);
        }
        if (executionConfig.getRampUp() > 0) {
            HtmlReportModule.printStatLine("Ramp up:", executionConfig.getRampUp(), "ms", null, null, null, out);
        }
        out.println("\t<tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>");
        out.println("\t<tr valign='top'>");
        out.println("\t\t<th>&nbsp;</th>");
        out.println("\t\t<th>Measured<br/>(" + counters[0].getClockName() + ")</th>");
        out.println("\t\t<th>Required</th>");
        for (int i = 1; i < counters.length; ++i) {
            out.println("\t\t<th>Measured<br/>(" + counters[i].getClockName() + ")</th>");
        }
        out.println("\t</tr>");
        HtmlReportModule.printDurationStats(counters, requirement, out);
        HtmlReportModule.printThroughputStats(counters, requirement, out);
        HtmlReportModule.printMinStats(counters, requirement, out);
        HtmlReportModule.printAverageStats(counters, requirement, out);
        HtmlReportModule.printPercentileStats(counters, requirement, out);
        HtmlReportModule.printMaxStats(counters, requirement, out);
        out.println("\t\t\t</table>");
    }

    private static void printDurationStats(LatencyCounter[] counters, PerformanceRequirement requirement, PrintWriter out) {
        Verdict verdict = ReportUtil.totalTimeVerdict(counters[0], requirement);
        Long required = requirement != null && requirement.getTotalTime() > 0 ? Long.valueOf(requirement.getTotalTime()) : null;
        long[] secondaryValues = null;
        if (counters.length > 1) {
            secondaryValues = new long[counters.length - 1];
            for (int i = 1; i < counters.length; ++i) {
                secondaryValues[i - 1] = counters[i].duration();
            }
        }
        HtmlReportModule.printStatMsLine("Execution time:", counters[0].duration(), required, secondaryValues, verdict, out);
    }

    private static void printThroughputStats(LatencyCounter[] counters, PerformanceRequirement requirement, PrintWriter out) {
        Verdict verdict = ReportUtil.throughputVerdict(counters[0], requirement);
        Long required = requirement != null && requirement.getThroughput() > 0 ? Long.valueOf(requirement.getThroughput()) : null;
        long[] secondaryValues = null;
        if (counters.length > 1) {
            secondaryValues = new long[counters.length - 1];
            for (int i = 1; i < counters.length; ++i) {
                secondaryValues[i - 1] = (long)counters[i].throughput();
            }
        }
        HtmlReportModule.printStatLine("Throughput:", (long)counters[0].throughput(), "/ s", required, secondaryValues, verdict, out);
    }

    private static void printMinStats(LatencyCounter[] counters, PerformanceRequirement requirement, PrintWriter out) {
        long[] secondaryValues = null;
        if (counters.length > 1) {
            secondaryValues = new long[counters.length - 1];
            for (int i = 1; i < counters.length; ++i) {
                secondaryValues[i - 1] = counters[i].minLatency();
            }
        }
        HtmlReportModule.printStatMsLine("Min. latency:", counters[0].minLatency(), null, secondaryValues, Verdict.IGNORED, out);
    }

    private static void printAverageStats(LatencyCounter[] counters, PerformanceRequirement requirement, PrintWriter out) {
        Verdict verdict = ReportUtil.averageVerdict(counters[0], requirement);
        Long required = requirement != null && requirement.getAverage() > 0 ? Long.valueOf(requirement.getAverage()) : null;
        long[] secondaryValues = null;
        if (counters.length > 1) {
            secondaryValues = new long[counters.length - 1];
            for (int i = 1; i < counters.length; ++i) {
                secondaryValues[i - 1] = (long)counters[i].averageLatency();
            }
        }
        HtmlReportModule.printStatMsLine("Average latency:", (long)counters[0].averageLatency(), required, secondaryValues, verdict, out);
    }

    private static void printPercentileStats(LatencyCounter[] counters, PerformanceRequirement requirement, PrintWriter out) {
        if (requirement == null || requirement.getPercentileRequirements().length == 0) {
            HtmlReportModule.printPercentileStats(counters, 50, null, out);
            HtmlReportModule.printPercentileStats(counters, 90, null, out);
        } else {
            for (PercentileRequirement percentileRequirement : requirement.getPercentileRequirements()) {
                HtmlReportModule.printPercentileStats(counters, percentileRequirement.getPercentage(), Long.valueOf(percentileRequirement.getMillis()), out);
            }
        }
    }

    private static void printPercentileStats(LatencyCounter[] counters, int percentage, Long requiredMillis, PrintWriter out) {
        String label = percentage == 50 ? "Median:" : percentage + "%:";
        Verdict verdict = ReportUtil.percentileVerdict(counters[0], percentage, requiredMillis);
        long[] secondaryValues = null;
        if (counters.length > 1) {
            secondaryValues = new long[counters.length - 1];
            for (int i = 1; i < counters.length; ++i) {
                secondaryValues[i - 1] = counters[i].percentileLatency(percentage);
            }
        }
        HtmlReportModule.printStatMsLine(label, counters[0].percentileLatency(percentage), requiredMillis, secondaryValues, verdict, out);
    }

    private static void printMaxStats(LatencyCounter[] counters, PerformanceRequirement requirement, PrintWriter out) {
        Verdict verdict = ReportUtil.maxVerdict(counters[0], requirement);
        Long required = requirement != null && requirement.getMax() > 0 ? Long.valueOf(requirement.getMax()) : null;
        long[] secondaryValues = null;
        if (counters.length > 1) {
            secondaryValues = new long[counters.length - 1];
            for (int i = 1; i < counters.length; ++i) {
                secondaryValues[i - 1] = counters[i].maxLatency();
            }
        }
        HtmlReportModule.printStatMsLine("Max latency:", counters[0].maxLatency(), required, secondaryValues, verdict, out);
    }

    private static void printStatMsLine(String label, long mainValue, Long requirement, long[] secondaryValues, Verdict verdict, PrintWriter out) {
        HtmlReportModule.printStatLine(label, mainValue, "ms", requirement, secondaryValues, verdict, out);
    }

    private static void printStatLine(String label, long value, String unit, Long requirement, long[] secondaryValues, Verdict verdict, PrintWriter out) {
        out.println("\t\t\t\t<tr>");
        out.println("\t\t\t\t\t<th align='right' valign='top'>" + HtmlReportModule.format(label, verdict) + "</th>");
        out.println("\t\t\t\t\t<td align='right'>" + HtmlReportModule.format(value, unit, verdict) + "</td>");
        out.println("\t\t\t\t\t<td align='right'>" + HtmlReportModule.format(requirement, unit, verdict) + "</td>");
        if (secondaryValues != null) {
            for (long secondaryValue : secondaryValues) {
                out.println("\t\t\t\t\t<td align='right'>" + HtmlReportModule.format(secondaryValue, unit, null) + "</td>");
            }
        }
        out.println("\t\t\t\t</tr>");
    }

    private static String format(Long number, String unit, Verdict verdict) {
        if (number == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(lf.format(number));
        if (unit != null) {
            builder.append(' ').append(unit);
        }
        return HtmlReportModule.format(builder, verdict);
    }

    private static String format(CharSequence text, Verdict verdict) {
        StringBuilder builder = new StringBuilder();
        if (verdict != null) {
            switch (verdict) {
                case SUCCESS: {
                    builder.append("<b style='color:#00BB00'>");
                    break;
                }
                case FAILURE: {
                    builder.append("<b style='color:RED'>");
                    break;
                }
            }
        }
        builder.append(text);
        if (verdict != null && verdict != Verdict.IGNORED) {
            builder.append("</b>");
        }
        return builder.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

