/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.Ref;
import au.net.zeus.collection.ReferenceIterator;
import au.net.zeus.collection.ReferencedQueue;
import au.net.zeus.collection.Referrer;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Deque;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceDeque<T>
extends ReferencedQueue<T>
implements Deque<T> {
    private static final long serialVersionUID = 1L;
    private final Deque<Referrer<T>> deque;

    ReferenceDeque(Deque<Referrer<T>> deque, Ref type, boolean gcThreads, long gcCycle) {
        super(deque, type, gcThreads, gcCycle);
        this.deque = deque;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Builder required");
    }

    @Override
    public void addFirst(T e) {
        this.processQueue();
        Referrer<T> r = this.wrapObj(e, true, false);
        this.deque.addFirst(r);
    }

    @Override
    public void addLast(T e) {
        this.processQueue();
        Referrer<T> r = this.wrapObj(e, true, false);
        this.deque.addLast(r);
    }

    @Override
    public boolean offerFirst(T e) {
        this.processQueue();
        Referrer<T> r = this.wrapObj(e, true, false);
        return this.deque.offerFirst(r);
    }

    @Override
    public boolean offerLast(T e) {
        this.processQueue();
        Referrer<T> r = this.wrapObj(e, true, false);
        return this.deque.offerLast(r);
    }

    @Override
    public T removeFirst() {
        this.processQueue();
        Referrer<T> t = this.deque.removeFirst();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T removeLast() {
        this.processQueue();
        Referrer<T> t = this.deque.removeLast();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T pollFirst() {
        this.processQueue();
        Referrer<T> t = this.deque.pollFirst();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T pollLast() {
        this.processQueue();
        Referrer<T> t = this.deque.pollLast();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T getFirst() {
        this.processQueue();
        Referrer<T> t = this.deque.getFirst();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T getLast() {
        this.processQueue();
        Referrer<T> t = this.deque.getLast();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T peekFirst() {
        this.processQueue();
        Referrer<T> t = this.deque.peekFirst();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T peekLast() {
        this.processQueue();
        Referrer<T> t = this.deque.peekLast();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        this.processQueue();
        Referrer<Object> r = this.wrapObj(o, false, true);
        return this.deque.removeFirstOccurrence(r);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        this.processQueue();
        Referrer<Object> r = this.wrapObj(o, false, true);
        return this.deque.removeLastOccurrence(r);
    }

    @Override
    public void push(T e) {
        this.processQueue();
        Referrer<T> r = this.wrapObj(e, true, false);
        this.deque.push(r);
    }

    @Override
    public T pop() {
        this.processQueue();
        Referrer<T> t = this.deque.pop();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public Iterator<T> descendingIterator() {
        return new ReferenceIterator<T>(this.deque.descendingIterator());
    }
}

