/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.Ref;
import au.net.zeus.collection.ReferenceIterator;
import au.net.zeus.collection.ReferenceQueuingFactory;
import au.net.zeus.collection.ReferenceSortedSet;
import au.net.zeus.collection.Referrer;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.NavigableSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceNavigableSet<T>
extends ReferenceSortedSet<T>
implements NavigableSet<T> {
    private static final long serialVersionUID = 1L;
    private final NavigableSet<Referrer<T>> set;

    public ReferenceNavigableSet(NavigableSet<Referrer<T>> set, Ref type, boolean gcThreads, long gcCycle) {
        super(set, type, gcThreads, gcCycle);
        this.set = set;
    }

    ReferenceNavigableSet(NavigableSet<Referrer<T>> set, ReferenceQueuingFactory<T, Referrer<T>> rqf, Ref type) {
        super(set, rqf, type);
        this.set = set;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Builder required");
    }

    @Override
    public T lower(T e) {
        this.processQueue();
        Referrer<T> t = this.set.lower(this.wrapObj(e, false, true));
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T floor(T e) {
        this.processQueue();
        Referrer<T> t = this.set.floor(this.wrapObj(e, false, true));
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T ceiling(T e) {
        this.processQueue();
        Referrer<T> t = this.set.ceiling(this.wrapObj(e, false, true));
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T higher(T e) {
        this.processQueue();
        Referrer<T> t = this.set.higher(this.wrapObj(e, false, true));
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T pollFirst() {
        this.processQueue();
        Referrer<T> t = this.set.pollFirst();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T pollLast() {
        this.processQueue();
        Referrer<T> t = this.set.pollLast();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public NavigableSet<T> descendingSet() {
        this.processQueue();
        return new ReferenceNavigableSet<T>(this.set.descendingSet(), this.getRQF(), null);
    }

    @Override
    public Iterator<T> descendingIterator() {
        this.processQueue();
        return new ReferenceIterator<T>(this.set.descendingIterator());
    }

    @Override
    public NavigableSet<T> subSet(T fromElement, boolean fromInclusive, T toElement, boolean toInclusive) {
        this.processQueue();
        return new ReferenceNavigableSet<T>(this.set.subSet(this.wrapObj(fromElement, false, true), fromInclusive, this.wrapObj(toElement, false, true), toInclusive), this.getRQF(), this.getRef());
    }

    @Override
    public NavigableSet<T> headSet(T toElement, boolean inclusive) {
        this.processQueue();
        return new ReferenceNavigableSet<T>(this.set.headSet(this.wrapObj(toElement, false, true), inclusive), this.getRQF(), this.getRef());
    }

    @Override
    public NavigableSet<T> tailSet(T fromElement, boolean inclusive) {
        this.processQueue();
        return new ReferenceNavigableSet<T>(this.set.tailSet(this.wrapObj(fromElement, false, true), inclusive), this.getRQF(), this.getRef());
    }
}

