/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.Ref;
import au.net.zeus.collection.ReferenceComparator;
import au.net.zeus.collection.ReferenceQueuingFactory;
import au.net.zeus.collection.ReferenceSet;
import au.net.zeus.collection.Referrer;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Comparator;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceSortedSet<T>
extends ReferenceSet<T>
implements SortedSet<T> {
    private static final long serialVersionUID = 1L;
    private final SortedSet<Referrer<T>> set;

    ReferenceSortedSet(SortedSet<Referrer<T>> set, Ref type, boolean gcThreads, long gcCycle) {
        super(set, type, gcThreads, gcCycle);
        this.set = set;
    }

    ReferenceSortedSet(SortedSet<Referrer<T>> set, ReferenceQueuingFactory<T, Referrer<T>> rqf, Ref type) {
        super(set, rqf, type);
        this.set = set;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Builder required");
    }

    @Override
    public Comparator<? super T> comparator() {
        this.processQueue();
        Comparator<Referrer<T>> c = this.set.comparator();
        if (c instanceof ReferenceComparator) {
            return ((ReferenceComparator)c).get();
        }
        return null;
    }

    @Override
    public SortedSet<T> subSet(T fromElement, T toElement) {
        this.processQueue();
        Referrer<T> from = this.wrapObj(fromElement, false, true);
        Referrer<T> to = this.wrapObj(toElement, false, true);
        return new ReferenceSortedSet<T>(this.set.subSet(from, to), this.getRQF(), this.getRef());
    }

    @Override
    public SortedSet<T> headSet(T toElement) {
        this.processQueue();
        Referrer<T> to = this.wrapObj(toElement, false, true);
        return new ReferenceSortedSet<T>(this.set.headSet(to), this.getRQF(), this.getRef());
    }

    @Override
    public SortedSet<T> tailSet(T fromElement) {
        this.processQueue();
        Referrer<T> from = this.wrapObj(fromElement, false, true);
        return new ReferenceSortedSet<T>(this.set.tailSet(from), this.getRQF(), this.getRef());
    }

    @Override
    public T first() {
        this.processQueue();
        Referrer<T> t = this.set.first();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T last() {
        this.processQueue();
        Referrer<T> t = this.set.last();
        if (t != null) {
            return t.get();
        }
        return null;
    }
}

