/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.jeri.internal.runtime.DgcServer;
import com.sun.jini.jeri.internal.runtime.Jeri;
import com.sun.jini.jeri.internal.runtime.ObjectTable;
import com.sun.jini.jeri.internal.runtime.Target;
import com.sun.jini.logging.Levels;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.rmi.server.ExportException;
import java.rmi.server.Unreferenced;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.export.ServerContext;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.io.MarshalInputStream;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.BasicInvocationDispatcher;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.InvocationDispatcher;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerCapabilities;

public class DgcRequestDispatcher
implements RequestDispatcher {
    private static final Logger logger = Logger.getLogger("net.jini.jeri.BasicJeriExporter");
    private static final Collection<Method> dgcDispatcherMethods = new ArrayList<Method>(2);
    private static final ServerCapabilities dgcServerCapabilities;
    private final Unreferenced unrefCallback;
    private final ObjectTable table;
    private final ConcurrentMap<Uuid, Target> idTable = new ConcurrentHashMap<Uuid, Target>();
    private final AtomicInteger dgcEnabledCount = new AtomicInteger();
    private final InvocationDispatcher dgcDispatcher;
    private final DgcServer dgcServer;

    DgcRequestDispatcher(Unreferenced unrefCallback, ObjectTable table) {
        this.unrefCallback = unrefCallback;
        this.table = table;
        try {
            this.dgcDispatcher = new BasicInvocationDispatcher(dgcDispatcherMethods, dgcServerCapabilities, null, null, this.getClass().getClassLoader()){

                @Override
                protected ObjectInputStream createMarshalInputStream(Object impl, InboundRequest request, boolean integrity, Collection context) throws IOException {
                    ClassLoader loader = this.getClassLoader();
                    return new MarshalInputStream(request.getRequestInputStream(), loader, integrity, loader, Collections.unmodifiableCollection(context));
                }
            };
        }
        catch (ExportException e) {
            throw new AssertionError();
        }
        this.dgcServer = table.getDgcServer(this);
    }

    boolean forTable(ObjectTable table) {
        return this.table == table;
    }

    boolean isReferenced() {
        return !this.idTable.isEmpty();
    }

    Target get(Uuid id) {
        return (Target)this.idTable.get(id);
    }

    void put(Target target) throws ExportException {
        Uuid id = target.getObjectIdentifier();
        if (id.equals(Jeri.DGC_ID)) {
            throw new ExportException("object identifier reserved for DGC");
        }
        Target exists = this.idTable.putIfAbsent(id, target);
        if (exists != null) {
            throw new ExportException("object identifier already in use");
        }
        if (target.getEnableDGC()) {
            this.dgcEnabledCount.incrementAndGet();
        }
    }

    void remove(Target target, boolean gc) {
        Uuid id = target.getObjectIdentifier();
        boolean removed = this.idTable.remove(id, target);
        if (target.getEnableDGC() && removed) {
            int count = this.dgcEnabledCount.decrementAndGet();
            assert (count >= 0);
        }
        if (gc && this.idTable.isEmpty()) {
            this.unrefCallback.unreferenced();
        }
    }

    private boolean hasDgcEnabledTargets() {
        return this.dgcEnabledCount.get() > 0;
    }

    @Override
    public void dispatch(InboundRequest request) {
        block8: {
            try {
                InputStream in = request.getRequestInputStream();
                Uuid id = UuidFactory.read(in);
                Target target = null;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "id={0}", id);
                }
                try {
                    if (id.equals(Jeri.DGC_ID)) {
                        this.dispatchDgcRequest(request);
                        return;
                    }
                    target = this.get(id);
                    if (target == null) {
                        logger.log(Level.FINEST, "id not in table");
                        throw new ObjectTable.NoSuchObject();
                    }
                    target.dispatch(request);
                }
                catch (ObjectTable.NoSuchObject e) {
                    in.close();
                    OutputStream out = request.getResponseOutputStream();
                    out.write(0);
                    out.close();
                    if (logger.isLoggable(Levels.FAILED)) {
                        logger.log(Levels.FAILED, "no such object: {0}", id);
                    }
                }
            }
            catch (IOException e) {
                request.abort();
                if (!logger.isLoggable(Levels.FAILED)) break block8;
                logger.log(Levels.FAILED, "I/O exception dispatching request", e);
            }
        }
    }

    private void dispatchDgcRequest(final InboundRequest request) throws IOException, ObjectTable.NoSuchObject {
        if (!this.hasDgcEnabledTargets()) {
            logger.log(Level.FINEST, "no DGC-enabled targets");
            throw new ObjectTable.NoSuchObject();
        }
        OutputStream out = request.getResponseOutputStream();
        out.write(1);
        final ArrayList context = new ArrayList(5);
        request.populateContext(context);
        ServerContext.doWithServerContext(new Runnable(){

            @Override
            public void run() {
                DgcRequestDispatcher.this.dgcDispatcher.dispatch(DgcRequestDispatcher.this.dgcServer, request, context);
            }
        }, Collections.unmodifiableCollection(context));
    }

    static {
        Method[] methods = DgcServer.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            final Method m = methods[i];
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    m.setAccessible(true);
                    return null;
                }
            });
            dgcDispatcherMethods.add(m);
        }
        dgcServerCapabilities = new ServerCapabilities(){

            @Override
            public InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
                assert (constraints.equals(InvocationConstraints.EMPTY));
                return InvocationConstraints.EMPTY;
            }
        };
    }
}

