/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.PartialResultException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.UnknownTaskException;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Job {
    private TaskManager pool;
    private WakeupManager wm;
    private int pending = -1;
    Object[] results;
    int[] attempts;
    private Map tasks = new HashMap();
    static final Logger logger = TxnManagerImpl.participantLogger;

    public Job(TaskManager pool, WakeupManager wm) {
        this.wm = wm;
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean performWork(TaskManager.Task who, Object param) throws JobException {
        Integer tmp = null;
        Map map = this.tasks;
        synchronized (map) {
            tmp = (Integer)this.tasks.get(who);
        }
        if (tmp == null) {
            throw new UnknownTaskException();
        }
        int rank = tmp;
        int[] nArray = this.attempts;
        synchronized (this.attempts) {
            int n = rank;
            this.attempts[n] = this.attempts[n] + 1;
            // ** MonitorExit[var5_7] (shouldn't be in output)
            Object result = this.doWork(who, param);
            if (result == null) {
                return false;
            }
            try {
                this.reportDone(who, result);
            }
            catch (UnknownTaskException e) {
            }
            catch (PartialResultException e) {
            }
            catch (JobException e) {
                // empty catch block
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int attempt(TaskManager.Task who) throws JobException {
        Integer tmp = null;
        Map map = this.tasks;
        synchronized (map) {
            tmp = (Integer)this.tasks.get(who);
        }
        if (tmp == null) {
            throw new UnknownTaskException();
        }
        int rank = tmp;
        int[] nArray = this.attempts;
        synchronized (this.attempts) {
            // ** MonitorExit[var4_6] (shouldn't be in output)
            return this.attempts[rank];
        }
    }

    abstract Object doWork(TaskManager.Task var1, Object var2) throws JobException;

    abstract TaskManager.Task[] createTasks();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTasks() {
        TaskManager.Task[] tmp = this.createTasks();
        if (tmp != null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Job:scheduleTasks with {0} tasks", tmp.length);
            }
            this.results = new Object[tmp.length];
            this.attempts = new int[tmp.length];
            this.setPending(tmp.length);
            for (int i = 0; i < tmp.length; ++i) {
                Map map = this.tasks;
                synchronized (map) {
                    this.tasks.put(tmp[i], i);
                    this.pool.add(tmp[i]);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Job:scheduleTasks added {0} to thread pool", tmp[i]);
                    }
                    this.attempts[i] = 0;
                    continue;
                }
            }
        }
    }

    private synchronized void awaitPending(long waitFor) {
        if (this.pending < 0) {
            return;
        }
        if (this.pending == 0) {
            return;
        }
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Job:awaitPending waiting for {0} items", this.pending);
            }
            if (waitFor == Long.MAX_VALUE) {
                while (this.pending > 0) {
                    this.wait();
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.FINEST, "Job:awaitPending awoken");
                }
            } else {
                long start;
                long curr = start = System.currentTimeMillis();
                while (this.pending > 0 && curr - start < waitFor) {
                    this.wait(waitFor - (curr - start));
                    curr = System.currentTimeMillis();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void setPending(int num) {
        this.pending = num;
        if (this.pending <= 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Job:setPending notifying, pending = {0}", this.pending);
            }
            this.notifyAll();
        }
    }

    private synchronized void decrementPending() {
        --this.pending;
        if (this.pending <= 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Job:decrementPending notifying, pending = {0}", this.pending);
            }
            this.notifyAll();
        }
    }

    protected TaskManager getPool() {
        return this.pool;
    }

    protected WakeupManager getMgr() {
        return this.wm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportDone(TaskManager.Task who, Object param) throws JobException {
        if (param == null) {
            throw new NullPointerException("param must be non-null");
        }
        if (who == null) {
            throw new NullPointerException("task must be non-null");
        }
        Integer position = null;
        Object[] objectArray = this.tasks;
        synchronized (this.tasks) {
            position = (Integer)this.tasks.get(who);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (position == null) {
                throw new UnknownTaskException();
            }
            objectArray = this.results;
            synchronized (this.results) {
                if (this.results[position] == null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Job:reportDone who = {0}, param = {1}", new Object[]{who, param});
                    }
                } else {
                    throw new PartialResultException("result already set");
                }
                this.results[position.intValue()] = param;
                this.decrementPending();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleted(long waitFor) throws JobException {
        this.awaitPending(waitFor);
        Job job = this;
        synchronized (job) {
            if (this.pending == 0) {
                return true;
            }
            if (this.pending < 0) {
                throw new JobNotStartedException("No jobs started");
            }
            return false;
        }
    }

    abstract Object computeResult() throws JobException;

    public void stop() {
        Set s = this.tasks.keySet();
        Object[] vals = s.toArray();
        for (int i = 0; i < vals.length; ++i) {
            TaskManager.Task t = (TaskManager.Task)vals[i];
            this.pool.remove(t);
        }
        this.tasks = new HashMap();
        this.setPending(-1);
        this.results = null;
    }
}

