/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mercury;

import com.sun.jini.mercury.MailboxAdmin;
import com.sun.jini.mercury.MailboxBackEnd;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class MailboxAdminProxy
implements MailboxAdmin,
Serializable,
ReferentUuid {
    private static final long serialVersionUID = 2L;
    final MailboxBackEnd server;
    final Uuid proxyID;

    static MailboxAdminProxy create(MailboxBackEnd mailbox, Uuid id) {
        if (mailbox instanceof RemoteMethodControl) {
            return new ConstrainableMailboxAdminProxy(mailbox, id, null);
        }
        return new MailboxAdminProxy(mailbox, id);
    }

    private MailboxAdminProxy(MailboxBackEnd server, Uuid serviceProxyID) {
        this.server = server;
        this.proxyID = serviceProxyID;
    }

    @Override
    public Entry[] getLookupAttributes() throws RemoteException {
        return this.server.getLookupAttributes();
    }

    @Override
    public void addLookupAttributes(Entry[] attrSets) throws RemoteException {
        this.server.addLookupAttributes(attrSets);
    }

    @Override
    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) throws RemoteException {
        this.server.modifyLookupAttributes(attrSetTemplates, attrSets);
    }

    @Override
    public String[] getLookupGroups() throws RemoteException {
        return this.server.getLookupGroups();
    }

    @Override
    public void addLookupGroups(String[] groups) throws RemoteException {
        this.server.addLookupGroups(groups);
    }

    @Override
    public void removeLookupGroups(String[] groups) throws RemoteException {
        this.server.removeLookupGroups(groups);
    }

    @Override
    public void setLookupGroups(String[] groups) throws RemoteException {
        this.server.setLookupGroups(groups);
    }

    @Override
    public LookupLocator[] getLookupLocators() throws RemoteException {
        return this.server.getLookupLocators();
    }

    @Override
    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.server.addLookupLocators(locators);
    }

    @Override
    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.server.removeLookupLocators(locators);
    }

    @Override
    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.server.setLookupLocators(locators);
    }

    @Override
    public void destroy() throws RemoteException {
        this.server.destroy();
    }

    @Override
    public Uuid getReferentUuid() {
        return this.proxyID;
    }

    public int hashCode() {
        return this.proxyID.hashCode();
    }

    public boolean equals(Object o) {
        return ReferentUuids.compare(this, o);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.server == null) {
            throw new InvalidObjectException("MailboxProxy.readObject failure - server field is null");
        }
        if (this.proxyID == null) {
            throw new InvalidObjectException("MailboxProxy.proxyID failure - proxyID field is null");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data found when attempting to deserialize MailboxProxy instance");
    }

    static final class ConstrainableMailboxAdminProxy
    extends MailboxAdminProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 2L;

        private ConstrainableMailboxAdminProxy(MailboxBackEnd server, Uuid proxyID, MethodConstraints methodConstraints) {
            super(ConstrainableMailboxAdminProxy.constrainServer(server, methodConstraints), proxyID);
        }

        private static MailboxBackEnd constrainServer(MailboxBackEnd server, MethodConstraints constraints) {
            RemoteMethodControl constrainedServer = ((RemoteMethodControl)((Object)server)).setConstraints(constraints);
            return (MailboxBackEnd)((Object)constrainedServer);
        }

        @Override
        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableMailboxAdminProxy(this.server, this.proxyID, constraints);
        }

        @Override
        public MethodConstraints getConstraints() {
            return ((RemoteMethodControl)((Object)this.server)).getConstraints();
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator(this.server);
        }

        @Override
        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (!(this.server instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("MailboxAdminProxy.readObject failure - server does not implement RemoteMethodControl");
            }
        }
    }
}

