/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mercury;

import com.sun.jini.landlord.ConstrainableLandlordLease;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordProxyVerifier;
import com.sun.jini.mercury.ListenerProxy;
import com.sun.jini.mercury.MailboxAdminProxy;
import com.sun.jini.mercury.MailboxBackEnd;
import com.sun.jini.mercury.MailboxProxy;
import com.sun.jini.mercury.Registration;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

final class ProxyVerifier
implements TrustVerifier,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger("net.jini.security.trust");
    private static final String proxyVerifierSourceClass = ProxyVerifier.class.getName();
    private final RemoteMethodControl serverProxy;
    private final Uuid proxyID;

    ProxyVerifier(MailboxBackEnd serverProxy, Uuid proxyID) {
        if (!(serverProxy instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException("No verifier available for non-constrainable service");
        }
        if (!(serverProxy instanceof TrustEquivalence)) {
            throw new UnsupportedOperationException("Verifier requires service proxy to implement TrustEquivalence");
        }
        if (proxyID == null) {
            throw new IllegalArgumentException("Proxy id cannot be null");
        }
        this.serverProxy = (RemoteMethodControl)((Object)serverProxy);
        this.proxyID = proxyID;
    }

    @Override
    public boolean isTrustedObject(Object obj, TrustVerifier.Context ctx) throws RemoteException {
        RemoteMethodControl otherServerProxy;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(proxyVerifierSourceClass, "isTrustedObject", new Object[]{obj, ctx});
        }
        if (obj == null || ctx == null) {
            throw new NullPointerException("Arguments must not be null");
        }
        Uuid inputProxyID = null;
        if (obj instanceof Registration.ConstrainableRegistration) {
            Registration reg = (Registration)obj;
            if (!this.isTrustedObject(reg.lease, ctx) || !this.isTrustedObject(reg.listener, ctx)) {
                return false;
            }
            otherServerProxy = (RemoteMethodControl)((Object)reg.mailbox);
        } else if (obj instanceof MailboxBackEnd && obj instanceof RemoteMethodControl) {
            otherServerProxy = (RemoteMethodControl)obj;
            inputProxyID = this.proxyID;
        } else if (obj instanceof MailboxProxy.ConstrainableMailboxProxy) {
            otherServerProxy = (RemoteMethodControl)((Object)((MailboxProxy)obj).mailbox);
            inputProxyID = ((ReferentUuid)obj).getReferentUuid();
        } else if (obj instanceof MailboxAdminProxy.ConstrainableMailboxAdminProxy) {
            otherServerProxy = (RemoteMethodControl)((Object)((MailboxAdminProxy)obj).server);
            inputProxyID = ((ReferentUuid)obj).getReferentUuid();
        } else if (obj instanceof ListenerProxy.ConstrainableListenerProxy) {
            otherServerProxy = (RemoteMethodControl)((Object)((ListenerProxy)obj).server);
        } else {
            if (obj instanceof ConstrainableLandlordLease) {
                LandlordProxyVerifier lpv = new LandlordProxyVerifier((Landlord)((Object)this.serverProxy), this.proxyID);
                return lpv.isTrustedObject(obj, ctx);
            }
            logger.log(Level.FINEST, "Object {0} is not a supported type", obj);
            return false;
        }
        if (inputProxyID != null && !this.proxyID.equals(inputProxyID)) {
            return false;
        }
        MethodConstraints mc = otherServerProxy.getConstraints();
        TrustEquivalence trusted = (TrustEquivalence)((Object)this.serverProxy.setConstraints(mc));
        boolean result = trusted.checkTrustEquivalence(otherServerProxy);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(proxyVerifierSourceClass, "isTrustedObject", result);
        }
        return result;
    }
}

