/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.norm.CorruptedStoreException;
import com.sun.jini.norm.NormServerBaseImpl;
import com.sun.jini.norm.StoreException;
import com.sun.jini.norm.lookup.SubStore;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import com.sun.jini.system.FileSystem;
import com.sun.jini.thread.ReadersWriter;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.ConfigurationException;

class PersistentStore {
    private static final Logger logger = Logger.getLogger("com.sun.jini.norm");
    private ReliableLog log;
    private final ReadersWriter mutatorLock = new ReadersWriter();
    private static final ThreadLocal lockState = new ThreadLocal();
    private static final Long zero = 0L;
    private final File storeLocation;
    private final LogHandler logHandler;
    private final NormServerBaseImpl server;
    private int updateCount;
    private List subStores = new LinkedList();

    PersistentStore(String logDir, LogHandler logHandler, NormServerBaseImpl server) throws StoreException {
        this.logHandler = logHandler;
        this.server = server;
        if (logDir == null) {
            this.storeLocation = null;
        } else {
            this.storeLocation = new File(logDir);
            try {
                this.log = new ReliableLog(this.storeLocation.getCanonicalPath(), logHandler);
            }
            catch (IOException e) {
                throw new CorruptedStoreException("Failure creating reliable log", e);
            }
            try {
                this.log.recover();
            }
            catch (IOException e) {
                throw new CorruptedStoreException("Failure recovering reliable log", e);
            }
        }
    }

    void destroy() throws IOException {
        for (SubStore subStore : this.subStores) {
            subStore.prepareDestroy();
        }
        if (this.log != null) {
            this.log.deletePersistentStore();
            FileSystem.destroy(this.storeLocation, true);
        }
    }

    void addSubStore(SubStore subStore) throws StoreException {
        try {
            if (this.log == null) {
                subStore.setDirectory(null);
            } else {
                String subDir = subStore.subDirectory();
                if (subDir == null) {
                    subStore.setDirectory(this.storeLocation);
                } else {
                    subStore.setDirectory(new File(this.storeLocation, subDir));
                }
            }
            this.subStores.add(subStore);
        }
        catch (IOException e) {
            throw new StoreException("Failure adding substore " + subStore, e);
        }
        catch (ConfigurationException e) {
            throw new StoreException("Failure adding substore " + subStore, e);
        }
    }

    void acquireMutatorLock() {
        long longVal;
        Long lockStateVal = (Long)lockState.get();
        if (lockStateVal == null) {
            lockStateVal = zero;
        }
        if ((longVal = lockStateVal.longValue()) == 0L) {
            this.mutatorLock.readLock();
        }
        lockState.set(longVal + 1L);
    }

    void releaseMutatorLock() {
        long longVal;
        Long lockStateVal = (Long)lockState.get();
        if (lockStateVal == null) {
            lockStateVal = zero;
        }
        if ((longVal = lockStateVal.longValue()) == 0L) {
            return;
        }
        if (longVal == 1L) {
            this.mutatorLock.readUnlock();
            lockStateVal = zero;
        } else {
            lockStateVal = longVal - 1L;
        }
        lockState.set(lockStateVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(Object o) {
        if (this.log == null) {
            return;
        }
        Long lockStateVal = (Long)lockState.get();
        if (lockStateVal == null || lockStateVal == 0L) {
            throw new IllegalStateException("PersistentStore.update:Must acquire mutator lock before calling update()");
        }
        PersistentStore persistentStore = this;
        synchronized (persistentStore) {
            try {
                this.log.update(o, true);
                ++this.updateCount;
                this.server.updatePerformed(this.updateCount);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "IOException while updating log", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshot() throws IOException {
        if (this.log == null) {
            return;
        }
        try {
            this.mutatorLock.writeLock();
            this.updateCount = 0;
            this.log.snapshot();
        }
        finally {
            this.mutatorLock.writeUnlock();
        }
    }
}

