/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.outrigger.BaseHandle;
import com.sun.jini.outrigger.EntryHandleHashDesc;
import com.sun.jini.outrigger.EntryHandleTmplDesc;
import com.sun.jini.outrigger.EntryHolder;
import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.LeaseDesc;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.Transactable;
import com.sun.jini.outrigger.TransactableMgr;
import com.sun.jini.outrigger.TxnState;
import java.util.Collection;
import net.jini.io.MarshalledInstance;

class EntryHandle
extends BaseHandle
implements LeaseDesc,
Transactable {
    private long hash;
    private TxnState txnState;
    private boolean removePending = false;

    EntryHandle(EntryRep rep, TransactableMgr mgr, EntryHolder holder) {
        super(rep);
        long l = this.hash = rep != null ? EntryHandle.hashFor(rep, rep.numFields()) : -1L;
        if (mgr == null) {
            this.txnState = null;
        } else {
            if (holder == null) {
                throw new NullPointerException("EntryHandle:If mgr is non-null holder must be non-null");
            }
            this.txnState = new TxnState(mgr, 1, holder);
        }
    }

    @Override
    public LeasedResource getLeasedResource() {
        return this.rep();
    }

    long hash() {
        return this.hash;
    }

    static long hashFor(EntryRep rep, int numFields) {
        return EntryHandle.hashFor(rep, numFields, null);
    }

    private static long hashFor(EntryRep rep, int numFields, EntryHandleHashDesc hashDesc) {
        if (rep == null || numFields == 0) {
            return 0L;
        }
        int bitsPerField = Math.max(64 / numFields, 4);
        int fieldsInHash = 64 / bitsPerField;
        long mask = -1L >>> 64 - bitsPerField;
        long hash = 0L;
        long endField = Math.min(fieldsInHash, rep.numFields());
        int i = 0;
        while ((long)i < endField) {
            hash |= (EntryHandle.hashForField(rep, i) & mask) << i * bitsPerField;
            ++i;
        }
        if (hashDesc != null) {
            hashDesc.bitsPerField = bitsPerField;
            hashDesc.fieldsInHash = fieldsInHash;
            hashDesc.mask = mask;
        }
        return hash;
    }

    static EntryHandleTmplDesc descFor(EntryRep tmpl, int numFields) {
        EntryHandleHashDesc hashDesc = new EntryHandleHashDesc();
        EntryHandleTmplDesc tmplDesc = new EntryHandleTmplDesc();
        tmplDesc.hash = EntryHandle.hashFor(tmpl, numFields, hashDesc);
        for (int i = 0; i < hashDesc.fieldsInHash; ++i) {
            if (i >= tmpl.numFields() || tmpl.value(i) == null) continue;
            tmplDesc.mask |= hashDesc.mask << i * hashDesc.bitsPerField;
        }
        tmplDesc.hash &= tmplDesc.mask;
        return tmplDesc;
    }

    static long hashForField(EntryRep rep, int field) {
        MarshalledInstance v = rep.value(field);
        if (v == null) {
            return 0L;
        }
        return v.hashCode();
    }

    public String toString() {
        return "0x" + Long.toHexString(this.hash) + " [" + this.rep() + "]";
    }

    boolean canPerform(TransactableMgr mgr, int op) {
        if (this.txnState == null) {
            return true;
        }
        return this.txnState.canPerform(mgr, op);
    }

    boolean knownMgr(TransactableMgr mgr) {
        if (this.txnState == null) {
            return mgr == null;
        }
        return this.txnState.knownMgr(mgr);
    }

    boolean onlyMgr(TransactableMgr mgr) {
        if (this.txnState == null) {
            return false;
        }
        return this.txnState.onlyMgr(mgr);
    }

    boolean managed() {
        return this.txnState != null;
    }

    void addTxns(Collection collection) {
        if (this.txnState == null) {
            return;
        }
        this.txnState.addTxns(collection);
    }

    void add(TransactableMgr mgr, int op, EntryHolder holder) {
        if (this.txnState == null) {
            this.txnState = new TxnState(mgr, op, holder);
        } else {
            this.txnState.add(mgr, op);
        }
    }

    boolean promoteToTakeIfNeeded() {
        return this.txnState.promoteToTakeIfNeeded();
    }

    boolean isProvisionallyRemoved() {
        assert (Thread.holdsLock(this));
        return this.removePending;
    }

    void provisionallyRemove() {
        assert (Thread.holdsLock(this));
        assert (!this.removePending);
        this.removePending = true;
    }

    void removalComplete() {
        assert (Thread.holdsLock(this));
        if (this.removePending) {
            this.removePending = false;
            this.notifyAll();
        }
    }

    void waitOnCompleteRemoval() throws InterruptedException {
        assert (Thread.holdsLock(this));
        while (this.removePending) {
            this.wait();
        }
    }

    @Override
    public synchronized int prepare(TransactableMgr mgr, OutriggerServerImpl space) {
        if (this.txnState == null) {
            throw new IllegalStateException("Can't prepare an entry not involved in a transaction");
        }
        int rslt = this.txnState.prepare(mgr, space, this);
        if (this.txnState.empty()) {
            this.txnState = null;
        }
        return rslt;
    }

    @Override
    public synchronized void abort(TransactableMgr mgr, OutriggerServerImpl space) {
        if (this.txnState == null) {
            throw new IllegalStateException("Can't abort an entry not involved in a transaction");
        }
        boolean last = this.txnState.abort(mgr, space, this);
        if (last) {
            this.txnState = null;
        }
    }

    @Override
    public synchronized void commit(TransactableMgr mgr, OutriggerServerImpl space) {
        if (this.txnState == null) {
            throw new IllegalStateException("Can't commit an entry not involved in a transaction");
        }
        boolean last = this.txnState.commit(mgr, space, this);
        if (last) {
            this.txnState = null;
        }
    }
}

