/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

class FastList<T extends Node>
implements Iterable<T> {
    private final AtomicLong nextIndex = new AtomicLong(0L);
    private final Queue<T> baseQueue = new ConcurrentLinkedQueue<T>();

    FastList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T node) {
        T t = node;
        synchronized (t) {
            if (((Node)node).getList() != null) {
                throw new IllegalArgumentException("Attempt to reuse node " + node);
            }
            ((Node)node).setList(this);
        }
        ((Node)node).setIndex(this.nextIndex.getAndIncrement());
        this.baseQueue.add(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T node) {
        T t = node;
        synchronized (t) {
            if (((Node)node).getList() != this) {
                throw new IllegalArgumentException("Cannot remove a node from a list it is not on");
            }
            return ((Node)node).remove();
        }
    }

    public void reap() {
        long stopIndex = this.nextIndex.get();
        Iterator it = this.baseQueue.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node.getIndex() >= stopIndex) {
                return;
            }
            if (!node.removed()) continue;
            it.remove();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new FastListIteratorImpl();
    }

    Iterator<T> rawIterator() {
        return this.baseQueue.iterator();
    }

    private class FastListIteratorImpl
    implements Iterator<T> {
        private T removable;
        private T next;
        private final long index;
        private final Iterator<T> baseIterator;

        private FastListIteratorImpl() {
            this.index = FastList.this.nextIndex.get();
            this.baseIterator = FastList.this.baseQueue.iterator();
            this.next = this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removable = this.next;
            this.next = this.getNext();
            return this.removable;
        }

        @Override
        public void remove() {
            if (this.removable == null) {
                throw new IllegalStateException();
            }
            ((Node)this.removable).remove();
            this.removable = null;
        }

        private T getNext() {
            Node node;
            Node result = null;
            while (this.baseIterator.hasNext() && (node = (Node)this.baseIterator.next()).getIndex() < this.index) {
                if (node.removed()) {
                    this.baseIterator.remove();
                    continue;
                }
                result = node;
                break;
            }
            return result;
        }
    }

    static class Node {
        private volatile boolean removed;
        private volatile long index;
        private FastList<?> list;

        Node() {
        }

        synchronized boolean remove() {
            if (this.removed) {
                return false;
            }
            this.removed = true;
            return true;
        }

        synchronized void markOnList(FastList<?> list) {
            this.setList(list);
        }

        public boolean removed() {
            return this.removed;
        }

        long getIndex() {
            return this.index;
        }

        void setIndex(long index) {
            this.index = index;
        }

        FastList<?> getList() {
            return this.list;
        }

        void setList(FastList<?> list) {
            this.list = list;
        }
    }
}

