/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryHandle;
import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.QueryWatcher;
import com.sun.jini.outrigger.TemplateHandle;
import com.sun.jini.outrigger.Transactable;
import com.sun.jini.outrigger.TransactableMgr;
import com.sun.jini.outrigger.Txn;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import net.jini.core.transaction.TransactionException;
import net.jini.space.InternalSpaceException;

class TakeMultipleWatcher
extends QueryWatcher
implements Transactable {
    private final Set handles = new HashSet();
    private final int limit;
    private final WeakHashMap provisionallyRemovedEntrySet;
    private final Txn txn;
    private boolean resolved = false;
    private Throwable toThrow;
    private Set owners = new HashSet();
    private OutriggerServerImpl server;
    private boolean blocking = false;

    TakeMultipleWatcher(int limit, long expiration, long timestamp, long startOrdinal, WeakHashMap provisionallyRemovedEntrySet, Txn txn) {
        super(expiration, timestamp, startOrdinal);
        this.limit = limit;
        this.provisionallyRemovedEntrySet = provisionallyRemovedEntrySet;
        this.txn = txn;
    }

    @Override
    synchronized boolean addTemplateHandle(TemplateHandle h) {
        if (this.owners == null) {
            return false;
        }
        this.owners.add(h);
        if (this.server == null) {
            this.server = h.getServer();
        }
        return true;
    }

    @Override
    synchronized boolean catchUp(EntryTransition transition, long now) {
        if (this.resolved) {
            return true;
        }
        TransactableMgr transitionTxn = transition.getTxn();
        EntryHandle handle = transition.getHandle();
        if (this.handles.contains(handle)) {
            return false;
        }
        if (transition.isAvailable() && (null == transitionTxn || this.txn == transitionTxn) && this.server.attemptCapture(handle, this.txn, true, null, this.provisionallyRemovedEntrySet, now, this)) {
            this.captured(handle);
            return this.resolved;
        }
        return false;
    }

    @Override
    boolean isInterested(EntryTransition transition, long ordinal) {
        TransactableMgr transitionTxn = transition.getTxn();
        return ordinal > this.startOrdinal && !this.resolved && transition.isAvailable() && (null == transitionTxn || this.txn == transitionTxn);
    }

    @Override
    synchronized void process(EntryTransition transition, long now) {
        if (this.resolved) {
            return;
        }
        EntryHandle handle = transition.getHandle();
        if (this.handles.contains(handle)) {
            return;
        }
        if (this.server.attemptCapture(handle, this.txn, true, null, this.provisionallyRemovedEntrySet, now, this)) {
            this.captured(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void waitOnResolution() throws InterruptedException {
        TakeMultipleWatcher takeMultipleWatcher = this;
        synchronized (takeMultipleWatcher) {
            this.blocking = true;
            if (this.handles.size() > 0) {
                this.resolved = true;
            } else {
                while (!this.resolved) {
                    long sleepTime = this.getExpiration() - System.currentTimeMillis();
                    if (sleepTime <= 0L) {
                        this.resolved = true;
                        continue;
                    }
                    this.wait(sleepTime);
                }
            }
            for (TemplateHandle h : this.owners) {
                h.removeTransitionWatcher(this);
            }
        }
    }

    synchronized EntryHandle[] resolvedWithEntries() {
        if (!this.resolved) {
            throw new IllegalStateException("Query not yet resolved");
        }
        if (this.handles.isEmpty()) {
            return null;
        }
        EntryHandle[] rslt = new EntryHandle[this.handles.size()];
        return this.handles.toArray(rslt);
    }

    synchronized Throwable resolvedWithThrowable() {
        if (!this.resolved) {
            throw new IllegalStateException("Query not yet resolved");
        }
        return this.toThrow;
    }

    @Override
    boolean isResolved() {
        return this.resolved;
    }

    private void captured(EntryHandle handle) {
        this.handles.add(handle);
        if (this.handles.size() == this.limit || this.blocking) {
            this.resolved = true;
            this.notifyAll();
        }
        assert (this.handles.size() <= this.limit);
    }

    @Override
    public synchronized int prepare(TransactableMgr mgr, OutriggerServerImpl space) {
        assert (this.txn != null) : "Transactable method called on a non-transactional ConsumingWatcher";
        if (!this.resolved) {
            this.resolved = true;
            this.toThrow = new TransactionException("completed while operation in progress");
            this.notifyAll();
        }
        return 4;
    }

    @Override
    public void commit(TransactableMgr mgr, OutriggerServerImpl space) {
        throw new InternalSpaceException("committing a blocking query");
    }

    @Override
    public void abort(TransactableMgr mgr, OutriggerServerImpl space) {
        this.prepare(mgr, space);
    }
}

