/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.BaseHandle;
import com.sun.jini.outrigger.EntryHandle;
import com.sun.jini.outrigger.EntryHandleTmplDesc;
import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.TransitionWatcher;
import com.sun.jini.outrigger.WatchersForTemplateClass;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

class TemplateHandle
extends BaseHandle {
    private final Vector descs = new Vector();
    private final Set watchers = new HashSet();
    private final WatchersForTemplateClass owner;

    TemplateHandle(EntryRep tmpl, WatchersForTemplateClass owner) {
        super(tmpl);
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EntryHandleTmplDesc descFor(int numFields) {
        Vector vector = this.descs;
        synchronized (vector) {
            EntryHandleTmplDesc desc;
            if (numFields >= this.descs.size()) {
                this.descs.setSize(numFields + 1);
            }
            if ((desc = (EntryHandleTmplDesc)this.descs.elementAt(numFields)) == null) {
                desc = EntryHandle.descFor(this.rep(), numFields);
                this.descs.setElementAt(desc, numFields);
            }
            return desc;
        }
    }

    boolean matches(EntryRep entry) {
        return this.rep().matches(entry);
    }

    void addTransitionWatcher(TransitionWatcher watcher) {
        assert (Thread.holdsLock(this)) : "addTransitionWatcher() called without lock";
        if (watcher == null) {
            throw new NullPointerException("Watcher can not be null");
        }
        assert (!this.removed()) : "Added watcher to a removed TemplateHandle";
        this.watchers.add(watcher);
    }

    synchronized void removeTransitionWatcher(TransitionWatcher watcher) {
        if (watcher == null) {
            throw new NullPointerException("Watcher can not be null");
        }
        this.watchers.remove(watcher);
    }

    synchronized void collectInterested(Set set, EntryTransition transition, long ordinal) {
        for (TransitionWatcher w : this.watchers) {
            if (!w.isInterested(transition, ordinal)) continue;
            set.add(w);
        }
    }

    OutriggerServerImpl getServer() {
        return this.owner.getServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reap(long now) {
        TransitionWatcher[] content;
        TemplateHandle templateHandle = this;
        synchronized (templateHandle) {
            content = new TransitionWatcher[this.watchers.size()];
            this.watchers.toArray(content);
        }
        for (int i = 0; i < content.length; ++i) {
            content[i].removeIfExpired(now);
        }
    }

    boolean isEmpty() {
        assert (Thread.holdsLock(this)) : "isEmpty() called without lock";
        return this.watchers.isEmpty();
    }
}

