/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger.snaplogstore;

import com.sun.jini.outrigger.Recover;
import com.sun.jini.outrigger.StoredObject;
import com.sun.jini.outrigger.snaplogstore.BackEnd;
import com.sun.jini.outrigger.snaplogstore.ByteArrayWrapper;
import com.sun.jini.outrigger.snaplogstore.Resource;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jini.space.InternalSpaceException;

class PendingTxn
implements Serializable {
    private long id;
    private int state;
    private Hashtable ops;
    private StoredObject transaction;

    PendingTxn(Long id) {
        this.id = id;
        this.state = 1;
        this.ops = new Hashtable();
    }

    void addWrite(Resource entry) {
        this.ops.put(entry.getCookieAsWrapper(), new WriteOp(entry));
    }

    void addTake(byte[] cookie) {
        ByteArrayWrapper baw = new ByteArrayWrapper(cookie);
        if (this.ops.remove(baw) == null) {
            this.ops.put(baw, new TakeOp(cookie));
        }
    }

    Resource get(ByteArrayWrapper cookie) {
        PendingOp po = (PendingOp)this.ops.get(cookie);
        if (po instanceof WriteOp) {
            return ((WriteOp)po).entry;
        }
        return null;
    }

    Resource remove(ByteArrayWrapper cookie) {
        Resource entry = this.get(cookie);
        if (entry != null) {
            this.ops.remove(cookie);
        }
        return entry;
    }

    boolean recover(Recover space) throws Exception {
        if (this.state != 3) {
            return false;
        }
        space.recoverTransaction(this.id, this.transaction);
        Enumeration e = this.ops.elements();
        while (e.hasMoreElements()) {
            PendingOp op = (PendingOp)e.nextElement();
            if (op instanceof WriteOp) {
                space.recoverWrite(((WriteOp)op).entry, this.id);
                continue;
            }
            if (op instanceof TakeOp) {
                space.recoverTake(ByteArrayWrapper.toUuid(((TakeOp)op).cookie), this.id);
                continue;
            }
            throw new InternalSpaceException("unknown operation type: " + op.getClass().getName());
        }
        return true;
    }

    void prepare(StoredObject tr) {
        this.transaction = tr;
        this.state = 3;
    }

    void commit(BackEnd processor) {
        Enumeration e = this.ops.elements();
        while (e.hasMoreElements()) {
            ((PendingOp)e.nextElement()).commit(processor);
        }
        this.state = 5;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object o) {
        try {
            return ((PendingTxn)o).id == this.id;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static class TakeOp
    extends PendingOp
    implements Serializable {
        byte[] cookie;

        TakeOp(byte[] cookie) {
            this.cookie = cookie;
        }

        @Override
        void commit(BackEnd processor) {
            processor.takeOp(this.cookie, null);
        }
    }

    static class WriteOp
    extends PendingOp
    implements Serializable {
        Resource entry;

        WriteOp(Resource entry) {
            this.entry = entry;
        }

        @Override
        void commit(BackEnd processor) {
            processor.writeOp(this.entry, null);
        }
    }

    static abstract class PendingOp
    implements Serializable {
        PendingOp() {
        }

        abstract void commit(BackEnd var1);
    }
}

